/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoMemoryException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.api.types.common.PrimitiveStorage;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.TornadoLIRGenerator;
import uk.ac.manchester.tornado.runtime.utils.TornadoUtils;

public class OCLVectorWrapper
implements XPUBuffer {
    private static final int INIT_VALUE = -1;
    protected final OCLDeviceContext deviceContext;
    private final long batchSize;
    private final JavaKind kind;
    private long bufferId;
    private long bufferOffset;
    private long bufferSize;
    private long setSubRegionSize;
    private Access access;

    public OCLVectorWrapper(OCLDeviceContext device, Object object, long batchSize, Access access) {
        TornadoInternalError.guarantee((boolean)(object instanceof PrimitiveStorage), (String)("Expecting a PrimitiveStorage type, but found: " + String.valueOf(object.getClass())), (Object[])new Object[0]);
        this.deviceContext = device;
        this.batchSize = batchSize;
        this.bufferId = -1L;
        this.bufferOffset = 0L;
        Object payload = TornadoUtils.getAnnotatedObjectFromField((Object)object, Payload.class);
        this.kind = this.getJavaKind(payload.getClass());
        this.bufferSize = this.sizeOf(payload);
        this.access = access;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void allocate(Object value, long batchSize, Access access) {
        TornadoInternalError.guarantee((boolean)(value instanceof PrimitiveStorage), (String)"Expecting a PrimitiveStorage type", (Object[])new Object[0]);
        Object hostArray = TornadoUtils.getAnnotatedObjectFromField((Object)value, Payload.class);
        this.bufferSize = batchSize <= 0L ? this.sizeOf(hostArray) : batchSize;
        if (this.bufferSize <= 0L) {
            throw new TornadoMemoryException("[ERROR] Bytes Allocated <= 0: " + this.bufferSize);
        }
        this.bufferId = this.deviceContext.getBufferProvider().getOrAllocateBufferWithSize(this.bufferSize, access);
        if (TornadoOptions.FULL_DEBUG) {
            new TornadoLogger().info("allocated: array kind=%s, size=%s, length offset=%d, header size=%d", new Object[]{this.kind.getJavaName(), RuntimeUtilities.humanReadableByteCount((long)this.bufferSize, (boolean)true), this.bufferOffset, TornadoOptions.PANAMA_OBJECT_HEADER_SIZE});
        }
    }

    public void markAsFreeBuffer() {
        TornadoInternalError.guarantee((this.bufferId != -1L ? 1 : 0) != 0, (String)"Fatal error: trying to deallocate an invalid buffer", (Object[])new Object[0]);
        this.deviceContext.getBufferProvider().markBufferReleased(this.bufferId, this.access);
        this.bufferId = -1L;
        this.bufferSize = -1L;
        if (TornadoOptions.FULL_DEBUG) {
            new TornadoLogger().info("deallocated: array kind=%s, size=%s, length offset=%d, header size=%d", new Object[]{this.kind.getJavaName(), RuntimeUtilities.humanReadableByteCount((long)this.bufferSize, (boolean)true), this.bufferOffset, TornadoOptions.PANAMA_OBJECT_HEADER_SIZE});
        }
    }

    public long size() {
        return this.bufferSize;
    }

    public void setSizeSubRegion(long batchSize) {
        this.setSubRegionSize = batchSize;
    }

    public int enqueueRead(long executionPlanId, Object value, long hostOffset, int[] events, boolean useDeps) {
        TornadoInternalError.guarantee((boolean)(value instanceof PrimitiveStorage), (String)"Expecting a PrimitiveStorage type", (Object[])new Object[0]);
        Object actualValue = TornadoUtils.getAnnotatedObjectFromField((Object)value, Payload.class);
        if (actualValue == null) {
            throw new TornadoRuntimeException("[ERROR] output data is NULL");
        }
        int returnEvent = this.enqueueReadArrayData(executionPlanId, this.toBuffer(), this.bufferOffset, this.bufferSize, actualValue, hostOffset, (int[])(useDeps ? events : null));
        return useDeps ? returnEvent : -1;
    }

    private int enqueueReadArrayData(long executionPlanId, long bufferId, long offset, long bytes, Object value, long hostOffset, int[] waitEvents) {
        if (this.kind == JavaKind.Int) {
            return this.deviceContext.enqueueReadBuffer(executionPlanId, bufferId, offset, bytes, (int[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Float) {
            return this.deviceContext.enqueueReadBuffer(executionPlanId, bufferId, offset, bytes, (float[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Double) {
            return this.deviceContext.enqueueReadBuffer(executionPlanId, bufferId, offset, bytes, (double[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Long) {
            return this.deviceContext.enqueueReadBuffer(executionPlanId, bufferId, offset, bytes, (long[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Short) {
            return this.deviceContext.enqueueReadBuffer(executionPlanId, bufferId, offset, bytes, (short[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Byte) {
            return this.deviceContext.enqueueReadBuffer(executionPlanId, bufferId, offset, bytes, (byte[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Object) {
            if (value instanceof TornadoNativeArray) {
                TornadoNativeArray nativeArray = (TornadoNativeArray)value;
                return this.deviceContext.enqueueReadBuffer(executionPlanId, bufferId, offset, bytes, nativeArray.getSegmentWithHeader().address(), hostOffset, waitEvents);
            }
            throw new TornadoRuntimeException("Type not supported: " + String.valueOf(value.getClass()));
        }
        TornadoInternalError.shouldNotReachHere((String)"Expecting an array type");
        return -1;
    }

    public List<Integer> enqueueWrite(long executionPlanId, Object value, long batchSize, long hostOffset, int[] events, boolean useDeps) {
        TornadoInternalError.guarantee((boolean)(value instanceof PrimitiveStorage), (String)"Expecting a PrimitiveStorage type", (Object[])new Object[0]);
        Object array = TornadoUtils.getAnnotatedObjectFromField((Object)value, Payload.class);
        ArrayList<Integer> listEvents = new ArrayList<Integer>();
        if (array == null) {
            throw new TornadoRuntimeException("ERROR] Data to be copied is NULL");
        }
        int returnEvent = this.enqueueWriteArrayData(executionPlanId, this.toBuffer(), this.bufferOffset, this.bufferSize, array, hostOffset, (int[])(useDeps ? events : null));
        listEvents.add(returnEvent);
        return listEvents;
    }

    private int enqueueWriteArrayData(long executionPlanId, long bufferId, long offset, long bytes, Object value, long hostOffset, int[] waitEvents) {
        if (this.kind == JavaKind.Int) {
            return this.deviceContext.enqueueWriteBuffer(executionPlanId, bufferId, offset, bytes, (int[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Float) {
            return this.deviceContext.enqueueWriteBuffer(executionPlanId, bufferId, offset, bytes, (float[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Double) {
            return this.deviceContext.enqueueWriteBuffer(executionPlanId, bufferId, offset, bytes, (double[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Long) {
            return this.deviceContext.enqueueWriteBuffer(executionPlanId, bufferId, offset, bytes, (long[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Short) {
            return this.deviceContext.enqueueWriteBuffer(executionPlanId, bufferId, offset, bytes, (short[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Byte) {
            return this.deviceContext.enqueueWriteBuffer(executionPlanId, bufferId, offset, bytes, (byte[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Object) {
            if (value instanceof TornadoNativeArray) {
                TornadoNativeArray nativeArray = (TornadoNativeArray)value;
                return this.deviceContext.enqueueWriteBuffer(executionPlanId, bufferId, offset, bytes, nativeArray.getSegmentWithHeader().address(), hostOffset, waitEvents);
            }
            throw new TornadoRuntimeException("Type not supported: " + String.valueOf(value.getClass()));
        }
        TornadoInternalError.shouldNotReachHere((String)"Expecting an array type");
        return -1;
    }

    public void read(long executionPlanId, Object value) {
        this.read(executionPlanId, value, 0L, 0L, null, false);
    }

    public int read(long executionPlanId, Object value, long hostOffset, long partialReadSize, int[] events, boolean useDeps) {
        TornadoInternalError.guarantee((boolean)(value instanceof PrimitiveStorage), (String)"Expecting a PrimitiveStorage type", (Object[])new Object[0]);
        Object array = TornadoUtils.getAnnotatedObjectFromField((Object)value, Payload.class);
        if (array == null) {
            throw new TornadoRuntimeException("[ERROR] output data is NULL");
        }
        return this.readArrayData(executionPlanId, this.toBuffer(), this.bufferOffset, this.bufferSize, array, hostOffset, (int[])(useDeps ? events : null));
    }

    private int readArrayData(long executionPlanId, long bufferId, long offset, long bytes, Object value, long hostOffset, int[] waitEvents) {
        if (this.kind == JavaKind.Int) {
            return this.deviceContext.readBuffer(executionPlanId, bufferId, offset, bytes, (int[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Float) {
            return this.deviceContext.readBuffer(executionPlanId, bufferId, offset, bytes, (float[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Double) {
            return this.deviceContext.readBuffer(executionPlanId, bufferId, offset, bytes, (double[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Long) {
            return this.deviceContext.readBuffer(executionPlanId, bufferId, offset, bytes, (long[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Short) {
            return this.deviceContext.readBuffer(executionPlanId, bufferId, offset, bytes, (short[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Byte) {
            return this.deviceContext.readBuffer(executionPlanId, bufferId, offset, bytes, (byte[])value, hostOffset, waitEvents);
        }
        if (this.kind == JavaKind.Object) {
            if (value instanceof TornadoNativeArray) {
                TornadoNativeArray nativeArray = (TornadoNativeArray)value;
                return this.deviceContext.readBuffer(executionPlanId, bufferId, offset, bytes, nativeArray.getSegmentWithHeader().address(), hostOffset, waitEvents);
            }
            throw new TornadoRuntimeException("Type not supported: " + String.valueOf(value.getClass()));
        }
        TornadoInternalError.shouldNotReachHere((String)"Expecting an array type");
        return -1;
    }

    private long sizeOf(Object array) {
        long size;
        if (array instanceof TornadoNativeArray) {
            TornadoNativeArray nativeArray = (TornadoNativeArray)array;
            size = nativeArray.getNumBytesOfSegmentWithHeader();
        } else {
            size = array.getClass() == HalfFloat[].class ? (long)Array.getLength(array) * 2L : (long)Array.getLength(array) * (long)this.kind.getByteCount();
        }
        return size;
    }

    public long toBuffer() {
        return this.bufferId;
    }

    public void setBuffer(XPUBuffer.XPUBufferWrapper bufferWrapper) {
        this.bufferId = bufferWrapper.buffer;
        this.bufferOffset = bufferWrapper.bufferOffset;
        bufferWrapper.bufferOffset += this.size();
    }

    public long getBufferOffset() {
        return this.bufferOffset;
    }

    public String toString() {
        return String.format("buffer<%s> %s", this.kind.getJavaName(), RuntimeUtilities.humanReadableByteCount((long)this.bufferSize, (boolean)true));
    }

    public void write(long executionPlanId, Object value) {
        TornadoInternalError.guarantee((boolean)(value instanceof PrimitiveStorage), (String)"Expecting a PrimitiveStorage type", (Object[])new Object[0]);
        Object array = TornadoUtils.getAnnotatedObjectFromField((Object)value, Payload.class);
        if (array == null) {
            throw new TornadoRuntimeException("[ERROR] data is NULL");
        }
        this.writeArrayData(executionPlanId, this.toBuffer(), this.bufferOffset, this.bufferSize, array, 0L, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArrayData(long executionPlanId, long bufferId, long offset, long bytes, Object value, long hostOffset, int[] waitEvents) {
        if (this.kind == JavaKind.Int) {
            this.deviceContext.writeBuffer(executionPlanId, bufferId, offset, bytes, (int[])value, hostOffset, waitEvents);
            return;
        } else if (this.kind == JavaKind.Float) {
            this.deviceContext.writeBuffer(executionPlanId, bufferId, offset, bytes, (float[])value, hostOffset, waitEvents);
            return;
        } else if (this.kind == JavaKind.Double) {
            this.deviceContext.writeBuffer(executionPlanId, bufferId, offset, bytes, (double[])value, hostOffset, waitEvents);
            return;
        } else if (this.kind == JavaKind.Long) {
            this.deviceContext.writeBuffer(executionPlanId, bufferId, offset, bytes, (long[])value, hostOffset, waitEvents);
            return;
        } else if (this.kind == JavaKind.Short) {
            this.deviceContext.writeBuffer(executionPlanId, bufferId, offset, bytes, (short[])value, hostOffset, waitEvents);
            return;
        } else if (this.kind == JavaKind.Byte) {
            this.deviceContext.writeBuffer(executionPlanId, bufferId, offset, bytes, (byte[])value, hostOffset, waitEvents);
            return;
        } else if (this.kind == JavaKind.Object) {
            if (!(value instanceof TornadoNativeArray)) throw new TornadoRuntimeException("Data not supported: " + String.valueOf(value.getClass()));
            TornadoNativeArray nativeArray = (TornadoNativeArray)value;
            this.deviceContext.writeBuffer(executionPlanId, bufferId, offset, bytes, nativeArray.getSegmentWithHeader().address(), hostOffset, waitEvents);
            return;
        } else {
            TornadoInternalError.shouldNotReachHere((String)"Expecting an array type");
        }
    }

    private JavaKind getJavaKind(Class<?> type) {
        if (type.isArray()) {
            if (type == int[].class) {
                return JavaKind.Int;
            }
            if (type == float[].class) {
                return JavaKind.Float;
            }
            if (type == double[].class) {
                return JavaKind.Double;
            }
            if (type == long[].class) {
                return JavaKind.Long;
            }
            if (type == short[].class) {
                return JavaKind.Short;
            }
            if (type == byte[].class) {
                return JavaKind.Byte;
            }
            if (type == HalfFloat[].class) {
                return JavaKind.Object;
            }
            TornadoLIRGenerator.warn((String)"cannot wrap field: array type=%s", (Object[])new Object[]{type.getName()});
        } else {
            if (type == FloatArray.class || type == IntArray.class || type == DoubleArray.class || type == LongArray.class || type == ShortArray.class || type == CharArray.class || type == ByteArray.class || type == HalfFloatArray.class) {
                return JavaKind.Object;
            }
            TornadoInternalError.shouldNotReachHere((String)("The type should be an array, but found: " + String.valueOf(type)));
        }
        return null;
    }

    public long getSizeSubRegionSize() {
        return this.setSubRegionSize;
    }

    public long deallocate() {
        return this.deviceContext.getBufferProvider().deallocate(this.access);
    }

    public void mapOnDeviceMemoryRegion(long executionPlanId, XPUBuffer srcPointer, long offset) {
        throw new TornadoRuntimeException("Operation not supported");
    }

    public int getSizeOfType() {
        throw new TornadoRuntimeException("[ERROR] not implemented");
    }
}

