/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.lang.reflect.Array;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaKind;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.exceptions.TornadoMemoryException;
import uk.ac.manchester.tornado.api.exceptions.TornadoOutOfMemoryException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLLongArrayWrapper;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;

public class OCLMultiDimArrayWrapper<T, E>
extends OCLArrayWrapper<T> {
    private final Function<OCLDeviceContext, ? extends OCLArrayWrapper<E>> innerWrapperFactory;
    private final OCLLongArrayWrapper tableWrapper;
    private long[] addresses;
    private OCLArrayWrapper<E>[] wrappers;
    private final OCLDeviceContext deviceContext;
    private Access access;

    public OCLMultiDimArrayWrapper(OCLDeviceContext device, Function<OCLDeviceContext, ? extends OCLArrayWrapper<E>> factory, long batchSize, Access access) {
        super(device, JavaKind.Object, batchSize, access);
        this.deviceContext = device;
        this.access = access;
        this.innerWrapperFactory = factory;
        this.tableWrapper = new OCLLongArrayWrapper(device, batchSize, access);
    }

    @Override
    public long toBuffer() {
        return this.tableWrapper.toBuffer();
    }

    @Override
    public long size() {
        return this.tableWrapper.size();
    }

    @Override
    public void allocate(Object value, long batchSize, Access access) throws TornadoOutOfMemoryException, TornadoMemoryException {
        if (batchSize > 0L) {
            throw new TornadoMemoryException("[ERROR] BatchSize Allocation currently not supported. BatchSize = " + batchSize + " (bytes)");
        }
        if (Array.getLength(value) < 0) {
            throw new TornadoMemoryException("[ERROR] Bytes Allocated < 0: " + Array.getLength(value));
        }
        this.addresses = new long[Array.getLength(value)];
        this.wrappers = new OCLArrayWrapper[Array.getLength(value)];
        this.tableWrapper.allocate(this.addresses, batchSize, access);
        this.allocateElements(value, batchSize, access);
    }

    private void allocateElements(T values, long batchSize, Access access) {
        E[] elements = this.innerCast(values);
        try {
            for (int i = 0; i < elements.length; ++i) {
                this.wrappers[i] = this.innerWrapperFactory.apply(this.deviceContext);
                this.wrappers[i].allocate(elements[i], batchSize, access);
                this.addresses[i] = this.wrappers[i].toBuffer();
            }
        }
        catch (TornadoMemoryException | TornadoOutOfMemoryException e) {
            new TornadoLogger().fatal("OOM: multi-dim array: %s", new Object[]{e.getMessage()});
            System.exit(-1);
        }
    }

    private int writeElements(long executionPlanId, T values) {
        E[] elements = this.innerCast(values);
        for (int i = 0; i < elements.length; ++i) {
            this.wrappers[i].enqueueWrite(executionPlanId, elements[i], 0L, 0L, null, false);
        }
        return this.deviceContext.enqueueBarrier(executionPlanId);
    }

    private int readElements(long executionPlanId, T values) {
        E[] elements = this.innerCast(values);
        for (int i = 0; i < elements.length; ++i) {
            this.wrappers[i].enqueueRead(executionPlanId, elements[i], 0L, null, false);
        }
        return this.deviceContext.enqueueBarrier(executionPlanId);
    }

    private E[] innerCast(T value) {
        return (Object[])value;
    }

    @Override
    protected int enqueueReadArrayData(long executionPlanId, long bufferId, long offset, long bytes, T value, long hostOffset, int[] waitEvents) {
        return this.readElements(executionPlanId, value);
    }

    @Override
    protected int enqueueWriteArrayData(long executionPlanId, long bufferId, long offset, long bytes, T value, long hostOffset, int[] waitEvents) {
        if (hostOffset > 0L) {
            System.out.println("[WARNING] writing in offset 0");
        }
        this.tableWrapper.enqueueWrite(executionPlanId, this.addresses, 0L, 0L, null, false);
        return this.writeElements(executionPlanId, value);
    }

    @Override
    protected int readArrayData(long executionPlanId, long bufferId, long offset, long bytes, T value, long hostOffset, int[] waitEvents) {
        return this.readElements(executionPlanId, value);
    }

    @Override
    protected void writeArrayData(long executionPlanId, long bufferId, long offset, long bytes, T value, long hostOffset, int[] waitEvents) {
        if (hostOffset > 0L) {
            System.out.println("[WARNING] writing in offset 0");
        }
        this.tableWrapper.enqueueWrite(executionPlanId, this.addresses, 0L, 0L, null, false);
        this.writeElements(executionPlanId, value);
    }

    public int getSizeOfType() {
        throw new TornadoRuntimeException("[ERROR] OCLMultiDimArrayWrapper getSizeOfType not supported");
    }
}

