/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.memory.TornadoMemoryProvider;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.drivers.opencl.OCLContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLAtomicsBuffer;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLKernelStackFrame;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLMemoryManager
implements TornadoMemoryProvider {
    private static final int MAX_NUMBER_OF_ATOMICS_PER_KERNEL = 32;
    private static final int INTEGER_BYTES_SIZE = 4;
    private final OCLDeviceContext deviceContext;
    private Map<Long, OCLKernelStackFrame> oclKernelStackFrame = new ConcurrentHashMap<Long, OCLKernelStackFrame>();
    private long constantMemoryPointer;
    private long NON_EXISTING_ADDRESS = -1L;
    private long atomicsRegionPointer = -1L;

    public OCLMemoryManager(OCLDeviceContext deviceContext) {
        this.deviceContext = deviceContext;
    }

    public long getHeapSize() {
        return TornadoOptions.DEVICE_AVAILABLE_MEMORY;
    }

    public OCLKernelStackFrame createKernelStackFrame(long executionPlanId, int numberOfArguments) {
        if (!this.oclKernelStackFrame.containsKey(executionPlanId)) {
            long kernelStackFramePtr = this.deviceContext.getPlatformContext().createBuffer(4L, 24L).getBuffer();
            this.oclKernelStackFrame.put(executionPlanId, new OCLKernelStackFrame(kernelStackFramePtr, numberOfArguments, this.deviceContext));
        }
        return this.oclKernelStackFrame.get(executionPlanId);
    }

    public void releaseKernelStackFrame(long executionPlanId) {
        OCLKernelStackFrame stackFrame = this.oclKernelStackFrame.remove(executionPlanId);
        if (stackFrame != null) {
            stackFrame.invalidate();
        }
    }

    public XPUBuffer createAtomicsBuffer(int[] array, Access access) {
        return new OCLAtomicsBuffer(array, this.deviceContext, access);
    }

    public void allocateDeviceMemoryRegions() {
        this.constantMemoryPointer = this.createBuffer(4L, 20L).getBuffer();
        this.allocateAtomicRegion();
    }

    public OCLContext.OCLBufferResult createBuffer(long size, long flags) {
        return this.deviceContext.getPlatformContext().createBuffer(flags, size);
    }

    public void releaseBuffer(long bufferId) {
        this.deviceContext.getPlatformContext().releaseBuffer(bufferId);
    }

    long toConstantAddress() {
        return this.constantMemoryPointer;
    }

    long toAtomicAddress() {
        return this.atomicsRegionPointer;
    }

    void allocateAtomicRegion() {
        if (this.atomicsRegionPointer == this.NON_EXISTING_ADDRESS) {
            this.atomicsRegionPointer = this.deviceContext.getPlatformContext().createBuffer(17L, OCLMemoryManager.atomicRegionSize()).getBuffer();
        }
    }

    void deallocateAtomicRegion() {
        if (this.atomicsRegionPointer != this.NON_EXISTING_ADDRESS) {
            this.deviceContext.getPlatformContext().releaseBuffer(this.atomicsRegionPointer);
            this.atomicsRegionPointer = this.NON_EXISTING_ADDRESS;
        }
    }

    public static long atomicRegionSize() {
        return 128L;
    }
}

