/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLByteBuffer;
import uk.ac.manchester.tornado.runtime.common.KernelStackFrame;

public class OCLKernelStackFrame
extends OCLByteBuffer
implements KernelStackFrame {
    public static final int RETURN_VALUE_INDEX = 0;
    public static final int RESERVED_SLOTS = 3;
    private final ArrayList<KernelStackFrame.CallArgument> callArguments;
    private boolean isValid;

    OCLKernelStackFrame(long bufferId, int numArgs, OCLDeviceContext device) {
        super(device, bufferId, 0L, 24L);
        this.callArguments = new ArrayList(numArgs);
        this.buffer.clear();
        this.isValid = true;
    }

    public void addCallArgument(Object value, boolean isReferenceType) {
        this.callArguments.add(new KernelStackFrame.CallArgument(value, isReferenceType));
    }

    public void reset() {
        this.callArguments.clear();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
        this.deviceContext.getPlatformContext().releaseBuffer(this.toBuffer());
    }

    public List<KernelStackFrame.CallArgument> getCallArguments() {
        return this.callArguments;
    }

    public void setKernelContext(HashMap<Integer, Integer> map) {
        this.buffer.clear();
        for (int i = 0; i < 3; ++i) {
            if (map.containsKey(i)) {
                this.buffer.putLong(map.get(i).intValue());
                continue;
            }
            this.buffer.putLong(0L);
        }
    }
}

