/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoMemoryException;
import uk.ac.manchester.tornado.api.exceptions.TornadoOutOfMemoryException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.drivers.common.mm.PrimitiveSerialiser;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.mm.FieldBuffer;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLByteArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLCharArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLDoubleArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLFloatArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLIntArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLLongArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLMemorySegmentWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLShortArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLVectorWrapper;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.utils.TornadoUtils;

public class OCLFieldBuffer
implements XPUBuffer {
    private final long bytesObjectReference;
    private final boolean areCoopsEnabled;
    private final HotSpotResolvedJavaType resolvedType;
    private final HotSpotResolvedJavaField[] fields;
    private final FieldBuffer[] wrappedFields;
    private final Class<?> objectType;
    private final int hubOffset;
    private final int fieldsOffset;
    private final OCLDeviceContext deviceContext;
    private long bufferId;
    private long bufferOffset;
    private ByteBuffer buffer;
    private long setSubRegionSize;
    private final TornadoLogger logger;
    private final Access access;

    private OCLFieldBuffer(OCLDeviceContext device, Object object, Access access, boolean includeSuperClasses) {
        this.objectType = object.getClass();
        this.deviceContext = device;
        this.logger = new TornadoLogger(this.getClass());
        this.access = access;
        this.areCoopsEnabled = TornadoOptions.coopsUsed();
        this.bytesObjectReference = this.areCoopsEnabled ? 4L : 8L;
        this.hubOffset = TornadoCoreRuntime.getVMConfig().hubOffset;
        this.fieldsOffset = TornadoCoreRuntime.getVMConfig().instanceKlassFieldsOffset();
        this.resolvedType = (HotSpotResolvedJavaType)TornadoCoreRuntime.getVMRuntime().getHostJVMCIBackend().getMetaAccess().lookupJavaType(this.objectType);
        this.fields = (HotSpotResolvedJavaField[])this.resolvedType.getInstanceFields(includeSuperClasses);
        this.sortFieldsByOffset();
        this.wrappedFields = new FieldBuffer[this.fields.length];
        for (int index = 0; index < this.fields.length; ++index) {
            HotSpotResolvedJavaField field = this.fields[index];
            Field reflectedField = this.getField(this.findDeclaringClass(field), field.getName());
            Class<?> type = reflectedField.getType();
            if (TornadoOptions.DEBUG) {
                this.logger.trace("field: name=%s, kind=%s, offset=%d", new Object[]{field.getName(), type.getName(), field.getOffset()});
            }
            Object wrappedField = null;
            if (type.isArray()) {
                objectFromField = TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object);
                if (type == int[].class) {
                    wrappedField = new OCLIntArrayWrapper((int[])objectFromField, device, 0L, access);
                } else if (type == float[].class) {
                    wrappedField = new OCLFloatArrayWrapper((float[])objectFromField, device, 0L, access);
                } else if (type == double[].class) {
                    wrappedField = new OCLDoubleArrayWrapper((double[])objectFromField, device, 0L, access);
                } else if (type == long[].class) {
                    wrappedField = new OCLLongArrayWrapper((long[])objectFromField, device, 0L, access);
                } else if (type == short[].class) {
                    wrappedField = new OCLShortArrayWrapper((short[])objectFromField, device, 0L, access);
                } else if (type == char[].class) {
                    wrappedField = new OCLCharArrayWrapper((char[])objectFromField, device, 0L, access);
                } else if (type == byte[].class) {
                    wrappedField = new OCLByteArrayWrapper((byte[])objectFromField, device, 0L, access);
                } else {
                    this.logger.warn("cannot wrap field: array type=%s", new Object[]{type.getName()});
                }
            } else if (type == FloatArray.class) {
                objectFromField = TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object);
                size = ((FloatArray)objectFromField).getSegmentWithHeader().byteSize();
                wrappedField = new OCLMemorySegmentWrapper(size, device, 0L, access, OCLKind.FLOAT.getSizeInBytes());
            } else if (type == ByteArray.class) {
                objectFromField = TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object);
                size = ((ByteArray)objectFromField).getSegmentWithHeader().byteSize();
                wrappedField = new OCLMemorySegmentWrapper(size, device, 0L, access, OCLKind.CHAR.getSizeInBytes());
            } else if (type == DoubleArray.class) {
                objectFromField = TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object);
                size = ((DoubleArray)objectFromField).getSegmentWithHeader().byteSize();
                wrappedField = new OCLMemorySegmentWrapper(size, device, 0L, access, OCLKind.DOUBLE.getSizeInBytes());
            } else if (type == IntArray.class) {
                objectFromField = TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object);
                size = ((IntArray)objectFromField).getSegmentWithHeader().byteSize();
                wrappedField = new OCLMemorySegmentWrapper(size, device, 0L, access, OCLKind.INT.getSizeInBytes());
            } else if (type == ShortArray.class) {
                objectFromField = TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object);
                size = ((ShortArray)objectFromField).getSegmentWithHeader().byteSize();
                wrappedField = new OCLMemorySegmentWrapper(size, device, 0L, access, OCLKind.SHORT.getSizeInBytes());
            } else if (type == LongArray.class) {
                objectFromField = TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object);
                size = ((LongArray)objectFromField).getSegmentWithHeader().byteSize();
                wrappedField = new OCLMemorySegmentWrapper(size, device, 0L, access, OCLKind.LONG.getSizeInBytes());
            } else if (type == HalfFloatArray.class) {
                objectFromField = TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object);
                size = ((HalfFloatArray)objectFromField).getSegmentWithHeader().byteSize();
                wrappedField = new OCLMemorySegmentWrapper(size, device, 0L, access, OCLKind.SHORT.getSizeInBytes());
            } else if (object.getClass().getAnnotation(Vector.class) != null) {
                wrappedField = new OCLVectorWrapper(device, object, 0L, access);
            } else if (field.getJavaKind().isObject()) {
                wrappedField = new OCLFieldBuffer(device, TornadoUtils.getObjectFromField((Field)reflectedField, (Object)object), access, includeSuperClasses);
            }
            if (wrappedField == null) continue;
            this.wrappedFields[index] = new FieldBuffer(reflectedField, (XPUBuffer)wrappedField);
        }
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate((int)this.getObjectSize());
            this.buffer.order(this.deviceContext.getByteOrder());
        }
    }

    public OCLFieldBuffer(OCLDeviceContext device, Object object, Access access) {
        this(device, object, access, !OCLFieldBuffer.isChildOfTornadoNativeArray(object));
    }

    private static boolean isChildOfTornadoNativeArray(Object object) {
        for (Class<?> objectType = object.getClass(); objectType != null; objectType = objectType.getSuperclass()) {
            if (!objectType.getName().equals(TornadoNativeArray.class.getName())) continue;
            return true;
        }
        return false;
    }

    public void allocate(Object reference, long batchSize, Access access) throws TornadoOutOfMemoryException, TornadoMemoryException {
        if (TornadoOptions.DEBUG) {
            this.logger.debug("object: object=0x%x, class=%s", new Object[]{reference.hashCode(), reference.getClass().getName()});
        }
        this.bufferId = this.deviceContext.getBufferProvider().getOrAllocateBufferWithSize(this.size(), access);
        this.bufferOffset = 0L;
        this.setBuffer(new XPUBuffer.XPUBufferWrapper(this.bufferId, this.bufferOffset));
        if (TornadoOptions.DEBUG) {
            this.logger.debug("object: object=0x%x @ bufferId 0x%x", new Object[]{reference.hashCode(), this.bufferId});
        }
    }

    public void markAsFreeBuffer() throws TornadoMemoryException {
        this.deviceContext.getBufferProvider().markBufferReleased(this.bufferId, this.access);
        this.bufferId = -1L;
    }

    private Field getField(Class<?> type, String name) {
        Field result = null;
        try {
            result = type.getDeclaredField(name);
            result.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            if (type.getSuperclass() != null) {
                result = this.getField(type.getSuperclass(), name);
            }
            TornadoInternalError.shouldNotReachHere((String)"unable to get field: class=%s, field=%s", (Object[])new Object[]{type.getName(), name});
        }
        return result;
    }

    private void writeFieldToBuffer(int index, Field field, Object obj) {
        Class<?> fieldType = field.getType();
        if (fieldType.isPrimitive()) {
            try {
                PrimitiveSerialiser.put((ByteBuffer)this.buffer, (Object)field.get(obj));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                TornadoInternalError.shouldNotReachHere((String)"unable to write primitive to buffer: ", (Object[])new Object[]{e.getMessage()});
            }
        } else if (this.wrappedFields[index] != null) {
            if (this.areCoopsEnabled) {
                long relativeOffset = this.wrappedFields[index].getBufferOffset() - this.bufferOffset;
                int compressedOffset = (int)(relativeOffset / 8L);
                this.buffer.putInt(compressedOffset);
            } else {
                this.buffer.putInt((int)this.wrappedFields[index].getBufferOffset());
            }
        } else {
            TornadoInternalError.unimplemented((String)"field type %s", (Object[])new Object[]{fieldType.getName()});
        }
    }

    private void readFieldFromBuffer(int index, Field field, Object obj) {
        Class<?> fieldType = field.getType();
        if (fieldType.isPrimitive()) {
            try {
                if (fieldType == Integer.TYPE) {
                    field.setInt(obj, this.buffer.getInt());
                } else if (fieldType == Long.TYPE) {
                    field.setLong(obj, this.buffer.getLong());
                } else if (fieldType == Short.TYPE) {
                    field.setShort(obj, this.buffer.getShort());
                } else if (fieldType == Byte.TYPE) {
                    field.set(obj, this.buffer.get());
                } else if (fieldType == Float.TYPE) {
                    field.setFloat(obj, this.buffer.getFloat());
                } else if (fieldType == Double.TYPE) {
                    field.setDouble(obj, this.buffer.getDouble());
                }
            }
            catch (IllegalAccessException e) {
                TornadoInternalError.shouldNotReachHere((String)"unable to read field: ", (Object[])new Object[]{e.getMessage()});
            }
        } else if (this.wrappedFields[index] != null) {
            if (this.areCoopsEnabled) {
                this.buffer.getInt();
            } else {
                this.buffer.getLong();
            }
        } else {
            TornadoInternalError.unimplemented((String)"field type %s", (Object[])new Object[]{fieldType.getName()});
        }
    }

    private void sortFieldsByOffset() {
        for (int i = 0; i < this.fields.length; ++i) {
            for (int j = 0; j < this.fields.length; ++j) {
                if (this.fields[i].getOffset() >= this.fields[j].getOffset()) continue;
                HotSpotResolvedJavaField tmp = this.fields[j];
                this.fields[j] = this.fields[i];
                this.fields[i] = tmp;
            }
        }
    }

    private void serialise(Object object) {
        this.buffer.rewind();
        this.buffer.position(this.hubOffset);
        this.buffer.putLong(0L);
        if (this.fields.length > 0) {
            this.buffer.position(this.fields[0].getOffset());
            for (int i = 0; i < this.fields.length; ++i) {
                HotSpotResolvedJavaField field = this.fields[i];
                Field f = this.getField(this.findDeclaringClass(field), field.getName());
                if (TornadoOptions.DEBUG) {
                    this.logger.trace("writing field: name=%s, offset=%d", new Object[]{field.getName(), field.getOffset()});
                }
                this.buffer.position(field.getOffset());
                this.writeFieldToBuffer(i, f, object);
            }
        }
    }

    private void deserialise(Object object) {
        this.buffer.rewind();
        if (this.fields.length > 0) {
            this.buffer.position(this.fields[0].getOffset());
            for (int i = 0; i < this.fields.length; ++i) {
                HotSpotResolvedJavaField field = this.fields[i];
                Field f = this.getField(this.findDeclaringClass(field), field.getName());
                f.setAccessible(true);
                if (TornadoOptions.DEBUG) {
                    this.logger.trace("reading field: name=%s, offset=%d", new Object[]{field.getName(), field.getOffset()});
                }
                this.readFieldFromBuffer(i, f, object);
            }
        }
    }

    private Class<?> findDeclaringClass(HotSpotResolvedJavaField field) {
        Class<?> objectTypeTemp;
        for (objectTypeTemp = this.objectType; objectTypeTemp != null && !objectTypeTemp.getName().equals(field.getDeclaringClass().toJavaName()); objectTypeTemp = objectTypeTemp.getSuperclass()) {
        }
        if (objectTypeTemp == null) {
            throw new TornadoRuntimeException(String.format("Cannot find declaring class %s in hierarchy of %s for field %s", field.getDeclaringClass().toJavaName(), this.objectType.getName(), field.getName()));
        }
        return objectTypeTemp;
    }

    public void write(long executionPlanId, Object object) {
        this.serialise(object);
        this.deviceContext.writeBuffer(executionPlanId, this.toBuffer(), this.bufferOffset, this.getObjectSize(), this.buffer.array(), 0L, (int[])null);
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.wrappedFields[i] == null) continue;
            this.wrappedFields[i].write(executionPlanId, object);
        }
    }

    public long toBuffer() {
        return this.bufferId;
    }

    public void setBuffer(XPUBuffer.XPUBufferWrapper bufferWrapper) {
        this.bufferId = bufferWrapper.buffer;
        this.bufferOffset = bufferWrapper.bufferOffset;
        bufferWrapper.bufferOffset += this.getObjectSize();
        for (int i = 0; i < this.fields.length; ++i) {
            FieldBuffer fieldBuffer = this.wrappedFields[i];
            if (fieldBuffer == null) continue;
            fieldBuffer.setBuffer(bufferWrapper);
        }
    }

    public long getBufferOffset() {
        return this.bufferOffset;
    }

    public void read(long executionPlanId, Object object) {
        this.read(executionPlanId, object, 0L, 0L, null, false);
    }

    public int read(long executionPlanId, Object object, long hostOffset, long partialReadSize, int[] events, boolean useDeps) {
        this.buffer.position(this.buffer.capacity());
        int event = this.deviceContext.readBuffer(executionPlanId, this.toBuffer(), this.bufferOffset, this.getObjectSize(), this.buffer.array(), hostOffset, (int[])(useDeps ? events : null));
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.wrappedFields[i] == null) continue;
            this.wrappedFields[i].read(executionPlanId, object);
        }
        this.deserialise(object);
        return event;
    }

    public void clear() {
        this.buffer.rewind();
        while (this.buffer.hasRemaining()) {
            this.buffer.put((byte)0);
        }
        this.buffer.rewind();
    }

    public void dump() {
        this.dump(8);
    }

    protected void dump(int width) {
        System.out.printf("Buffer  : capacity = %s, in use = %s, device = %s \n", RuntimeUtilities.humanReadableByteCount((long)this.getObjectSize(), (boolean)true), RuntimeUtilities.humanReadableByteCount((long)this.buffer.position(), (boolean)true), this.deviceContext.getDevice().getDeviceName());
        for (int i = 0; i < this.buffer.position(); i += width) {
            System.out.printf("[0x%04x]: ", i);
            for (int j = 0; j < Math.min(this.buffer.capacity() - i, width); ++j) {
                if (j % 2 == 0) {
                    System.out.printf(" ", new Object[0]);
                }
                if (j < this.buffer.position() - i) {
                    System.out.printf("%02x", this.buffer.get(i + j));
                    continue;
                }
                System.out.printf("..", new Object[0]);
            }
            System.out.println();
        }
    }

    public int enqueueRead(long executionPlanId, Object reference, long hostOffset, int[] events, boolean useDeps) {
        int index = 0;
        int[] internalEvents = new int[this.fields.length];
        Arrays.fill(internalEvents, -1);
        for (FieldBuffer fb : this.wrappedFields) {
            if (fb == null) continue;
            internalEvents[index] = fb.enqueueRead(executionPlanId, reference, (int[])(useDeps ? events : null), useDeps);
            ++index;
        }
        internalEvents[index] = this.deviceContext.enqueueReadBuffer(executionPlanId, this.toBuffer(), this.bufferOffset, this.getObjectSize(), this.buffer.array(), hostOffset, (int[])(useDeps ? events : null));
        this.deserialise(reference);
        int returnEvent = ++index == 1 ? internalEvents[0] : this.deviceContext.enqueueMarker(executionPlanId, internalEvents);
        return useDeps ? returnEvent : -1;
    }

    public List<Integer> enqueueWrite(long executionPlanId, Object ref, long batchSize, long hostOffset, int[] events, boolean useDeps) {
        ArrayList<Integer> eventList = new ArrayList<Integer>();
        this.serialise(ref);
        eventList.add(this.deviceContext.enqueueWriteBuffer(executionPlanId, this.toBuffer(), this.bufferOffset, this.getObjectSize(), this.buffer.array(), hostOffset, (int[])(useDeps ? events : null)));
        for (FieldBuffer field : this.wrappedFields) {
            if (field == null) continue;
            eventList.addAll(field.enqueueWrite(executionPlanId, ref, (int[])(useDeps ? events : null), useDeps));
        }
        return eventList;
    }

    public String toString() {
        return String.format("object wrapper: type=%s, fields=%d\n", this.resolvedType.getName(), this.wrappedFields.length);
    }

    private long getObjectSize() {
        long size = this.fieldsOffset;
        if (this.fields.length > 0) {
            HotSpotResolvedJavaField field = this.fields[this.fields.length - 1];
            size = (long)field.getOffset() + (field.getJavaKind().isObject() ? this.bytesObjectReference : (long)field.getJavaKind().getByteCount());
        }
        if (this.areCoopsEnabled && size % 8L != 0L) {
            size += 8L - size % 8L;
        }
        return size;
    }

    public long size() {
        long size = this.getObjectSize();
        for (FieldBuffer wrappedField : this.wrappedFields) {
            if (wrappedField == null) continue;
            size += wrappedField.size();
        }
        return size;
    }

    public void setSizeSubRegion(long batchSize) {
        this.setSubRegionSize = batchSize;
    }

    public long getSizeSubRegionSize() {
        return this.setSubRegionSize;
    }

    public long deallocate() {
        return this.deviceContext.getBufferProvider().deallocate(this.access);
    }

    public void mapOnDeviceMemoryRegion(long executionPlanId, XPUBuffer srcPointer, long offset) {
        throw new UnsupportedOperationException();
    }

    public int getSizeOfType() {
        throw new TornadoRuntimeException("[ERROR] not implemented");
    }
}

