/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.nio.ByteBuffer;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;

public class OCLByteBuffer {
    private static final int BYTES_PER_INTEGER = 4;
    protected final long bytes;
    protected final OCLDeviceContext deviceContext;
    private final long oclBufferId;
    private final long offset;
    protected ByteBuffer buffer;

    public OCLByteBuffer(OCLDeviceContext deviceContext, long oclBufferId, long offset, long numBytes) {
        this.deviceContext = deviceContext;
        this.oclBufferId = oclBufferId;
        this.bytes = numBytes;
        this.offset = offset;
        this.buffer = ByteBuffer.allocate((int)numBytes);
        this.buffer.order(this.deviceContext.getByteOrder());
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public void read(long executionPlanId) {
        this.read(executionPlanId, null);
    }

    public void read(long executionPlanId, int[] events) {
        this.deviceContext.readBuffer(executionPlanId, this.toBuffer(), this.offset, this.bytes, this.buffer.array(), 0L, events);
    }

    public int read(long executionPlanId, long fromBuffer, int[] toArray) {
        return this.deviceContext.readBuffer(executionPlanId, fromBuffer, 0L, (long)(toArray.length * 4), toArray, 0L, (int[])null);
    }

    public int enqueueRead(long executionPlanId) {
        return this.enqueueRead(executionPlanId, null);
    }

    public int enqueueRead(long executionPlanId, int[] events) {
        return this.deviceContext.enqueueReadBuffer(executionPlanId, this.toBuffer(), this.offset, this.bytes, this.buffer.array(), 0L, events);
    }

    public void write(long executionPlanId) {
        this.write(executionPlanId, null);
    }

    public void write(long executionPlanId, int[] events) {
        this.deviceContext.writeBuffer(executionPlanId, this.toBuffer(), this.offset, this.bytes, this.buffer.array(), 0L, events);
    }

    public int enqueueWrite(long executionPlanId) {
        return this.enqueueWrite(executionPlanId, null);
    }

    public int enqueueWrite(long executionPlanId, int[] events) {
        return this.deviceContext.enqueueWriteBuffer(executionPlanId, this.toBuffer(), this.offset, this.bytes, this.buffer.array(), 0L, events);
    }

    public int enqueueWrite(long executionPlanId, long fromBuffer, int[] array, int offset, int[] events) {
        return this.deviceContext.enqueueWriteBuffer(executionPlanId, fromBuffer, (long)offset, (long)(4 * array.length), array, 0L, events);
    }

    public int enqueueRead(long executionPlanId, long fromBuffer, int[] array, int offset, int[] events) {
        return this.deviceContext.enqueueReadBuffer(executionPlanId, fromBuffer, (long)offset, (long)(4 * array.length), array, 0L, events);
    }

    public void dump() {
        this.dump(64);
    }

    public void dump(int width) {
        this.buffer.position(this.buffer.capacity());
        System.out.printf("Buffer  : capacity = %s, in use = %s, device = %s \n", RuntimeUtilities.humanReadableByteCount((long)this.bytes, (boolean)true), RuntimeUtilities.humanReadableByteCount((long)this.buffer.position(), (boolean)true), this.deviceContext.getDevice().getDeviceName());
        for (int i = 0; i < this.buffer.position(); i += width) {
            for (int j = 0; j < Math.min(this.buffer.capacity() - i, width); ++j) {
                if (j % 2 == 0) {
                    System.out.printf(" ", new Object[0]);
                }
                if (j < this.buffer.position() - i) {
                    System.out.printf("%02x", this.buffer.get(i + j));
                    continue;
                }
                System.out.printf("..", new Object[0]);
            }
            System.out.println();
        }
    }

    public byte get() {
        return this.buffer.get();
    }

    public ByteBuffer get(byte[] dst) {
        return this.buffer.get(dst);
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        return this.buffer.get(dst, offset, length);
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public int getAlignment() {
        return 64;
    }

    public char getChar() {
        return this.buffer.getChar();
    }

    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public long getSize() {
        return this.bytes;
    }

    public ByteBuffer put(byte b) {
        return this.buffer.put(b);
    }

    public final ByteBuffer put(byte[] src) {
        return this.buffer.put(src);
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        return this.buffer.put(src, offset, length);
    }

    public ByteBuffer put(ByteBuffer src) {
        return this.buffer.put(src);
    }

    public ByteBuffer put(int index, byte b) {
        return this.buffer.put(index, b);
    }

    public ByteBuffer putChar(char value) {
        return this.buffer.putChar(value);
    }

    public ByteBuffer putChar(int index, char value) {
        return this.buffer.putChar(index, value);
    }

    public ByteBuffer putDouble(double value) {
        return this.buffer.putDouble(value);
    }

    public ByteBuffer putDouble(int index, double value) {
        return this.buffer.putDouble(index, value);
    }

    public ByteBuffer putFloat(float value) {
        return this.buffer.putFloat(value);
    }

    public ByteBuffer putFloat(int index, float value) {
        return this.buffer.putFloat(index, value);
    }

    public ByteBuffer putInt(int value) {
        return this.buffer.putInt(value);
    }

    public ByteBuffer putInt(int index, int value) {
        return this.buffer.putInt(index, value);
    }

    public ByteBuffer putLong(int index, long value) {
        return this.buffer.putLong(index, value);
    }

    public ByteBuffer putLong(long value) {
        return this.buffer.putLong(value);
    }

    public ByteBuffer putShort(int index, short value) {
        return this.buffer.putShort(index, value);
    }

    public ByteBuffer putShort(short value) {
        return this.buffer.putShort(value);
    }

    public long toBuffer() {
        return this.oclBufferId;
    }

    public long getOffset() {
        return this.offset;
    }

    public long toConstantAddress() {
        return this.deviceContext.getMemoryManager().toConstantAddress();
    }

    public long toAtomicAddress() {
        return this.deviceContext.getMemoryManager().toAtomicAddress();
    }
}

