/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.exceptions.TornadoMemoryException;
import uk.ac.manchester.tornado.api.exceptions.TornadoOutOfMemoryException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLMemoryManager;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLAtomicsBuffer
implements XPUBuffer {
    private int[] atomicsList;
    private static final int OFFSET = 0;
    private final OCLDeviceContext deviceContext;
    private long setSubRegionSize;
    private Access access;
    private static final TornadoLogger logger = new TornadoLogger(OCLAtomicsBuffer.class);

    public OCLAtomicsBuffer(int[] arr, OCLDeviceContext deviceContext, Access access) {
        this.deviceContext = deviceContext;
        this.atomicsList = arr;
        this.access = access;
        deviceContext.getMemoryManager().allocateAtomicRegion();
    }

    public long toBuffer() {
        throw new TornadoRuntimeException("Not implemented");
    }

    public void setBuffer(XPUBuffer.XPUBufferWrapper bufferWrapper) {
        throw new TornadoRuntimeException("Not implemented");
    }

    public long getBufferOffset() {
        return 0L;
    }

    public void read(long executionPlanId, Object reference) {
        throw new TornadoRuntimeException("Not implemented");
    }

    public int read(long executionPlanId, Object reference, long hostOffset, long partialReadSize, int[] events, boolean useDeps) {
        throw new TornadoRuntimeException("Not implemented");
    }

    public void write(long executionPlanId, Object reference) {
        throw new TornadoRuntimeException("Not implemented");
    }

    public int enqueueRead(long executionPlanId, Object reference, long hostOffset, int[] events, boolean useDeps) {
        return this.deviceContext.readBuffer(executionPlanId, this.deviceContext.getMemoryManager().toAtomicAddress(), 0L, (long)(4 * this.atomicsList.length), this.atomicsList, 0L, events);
    }

    public List<Integer> enqueueWrite(long executionPlanId, Object reference, long batchSize, long hostOffset, int[] events, boolean useDeps) {
        if (this.atomicsList.length == 0) {
            return null;
        }
        return new ArrayList<Integer>(this.deviceContext.enqueueWriteBuffer(executionPlanId, this.deviceContext.getMemoryManager().toAtomicAddress(), 0L, (long)(4 * this.atomicsList.length), this.atomicsList, 0L, events));
    }

    public void allocate(Object reference, long batchSize, Access access) throws TornadoOutOfMemoryException, TornadoMemoryException {
        this.deviceContext.getMemoryManager().allocateAtomicRegion();
    }

    public void markAsFreeBuffer() throws TornadoMemoryException {
        logger.debug("Marking atomics buffer as free has no effect because we do not use the BufferProvider for this buffer.");
    }

    public long size() {
        return this.atomicsList.length * 4;
    }

    public void setSizeSubRegion(long batchSize) {
        this.setSubRegionSize = batchSize;
    }

    public long getSizeSubRegionSize() {
        return this.setSubRegionSize;
    }

    public int[] getIntBuffer() {
        return this.atomicsList;
    }

    public void setIntBuffer(int[] arr) {
        this.atomicsList = arr;
    }

    public void mapOnDeviceMemoryRegion(long executionPlanId, XPUBuffer srcPointer, long offset) {
        throw new TornadoRuntimeException("Not implemented");
    }

    public int getSizeOfType() {
        throw new TornadoRuntimeException("[ERROR] not implemented");
    }

    public long deallocate() {
        if (TornadoOptions.cleanUpAtomicsSpace()) {
            this.deviceContext.getMemoryManager().deallocateAtomicRegion();
            return OCLMemoryManager.atomicRegionSize();
        }
        return 0L;
    }
}

