/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoMemoryException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLByteBuffer;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public abstract class OCLArrayWrapper<T>
implements XPUBuffer {
    private static final int INIT_VALUE = -1;
    protected final OCLDeviceContext deviceContext;
    private final int arrayHeaderSize;
    private final int arrayLengthOffset;
    private final JavaKind kind;
    private final long batchSize;
    private long bufferId;
    private long bufferOffset;
    private long bufferSize;
    private long setSubRegionSize;
    private TornadoLogger logger;
    private Access access;

    protected OCLArrayWrapper(OCLDeviceContext device, JavaKind kind, long batchSize, Access access) {
        this.deviceContext = device;
        this.kind = kind;
        this.batchSize = batchSize;
        this.bufferId = -1L;
        this.bufferSize = -1L;
        this.bufferOffset = 0L;
        this.access = access;
        this.arrayLengthOffset = TornadoCoreRuntime.getVMConfig().arrayOopDescLengthOffset();
        this.arrayHeaderSize = TornadoCoreRuntime.getVMConfig().getArrayBaseOffset(kind);
        this.logger = new TornadoLogger(this.getClass());
    }

    protected OCLArrayWrapper(T array, OCLDeviceContext device, JavaKind kind, long batchSize, Access access) {
        this(device, kind, batchSize, access);
        this.bufferSize = this.sizeOf(array);
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    private T cast(Object array) {
        try {
            return (T)array;
        }
        catch (Error | Exception e) {
            TornadoInternalError.shouldNotReachHere((String)("[ERROR] Unable to cast object: " + e.getMessage()));
            return null;
        }
    }

    public void allocate(Object value, long batchSize, Access access) {
        T hostArray = this.cast(value);
        this.bufferSize = batchSize <= 0L ? this.sizeOf(hostArray) : this.sizeOfBatch(batchSize);
        if (this.bufferSize <= 0L) {
            throw new TornadoMemoryException("[ERROR] Bytes Allocated <= 0: " + this.bufferSize);
        }
        this.bufferId = this.deviceContext.getBufferProvider().getOrAllocateBufferWithSize(this.bufferSize, access);
        if (TornadoOptions.FULL_DEBUG) {
            this.logger.info("allocated: array kind=%s, size=%s, length offset=%d, header size=%d", new Object[]{this.kind.getJavaName(), RuntimeUtilities.humanReadableByteCount((long)this.bufferSize, (boolean)true), this.arrayLengthOffset, this.arrayHeaderSize});
            this.logger.info("allocated: %s", new Object[]{this.toString()});
        }
    }

    public void markAsFreeBuffer() {
        TornadoInternalError.guarantee((this.bufferId != -1L ? 1 : 0) != 0, (String)"Fatal error: trying to deallocate an invalid buffer", (Object[])new Object[0]);
        this.deviceContext.getBufferProvider().markBufferReleased(this.bufferId, this.access);
        this.bufferId = -1L;
        this.bufferSize = -1L;
        if (TornadoOptions.FULL_DEBUG) {
            this.logger.info("deallocated: array kind=%s, size=%s, length offset=%d, header size=%d", new Object[]{this.kind.getJavaName(), RuntimeUtilities.humanReadableByteCount((long)this.bufferSize, (boolean)true), this.arrayLengthOffset, this.arrayHeaderSize});
            this.logger.info("deallocated: %s", new Object[]{this.toString()});
        }
    }

    public long deallocate() {
        return this.deviceContext.getBufferProvider().deallocate(this.access);
    }

    public long size() {
        return this.bufferSize;
    }

    private OCLByteBuffer buildArrayHeader(int arraySize) {
        OCLByteBuffer header = this.getArrayHeader();
        for (int i = 0; i < this.arrayLengthOffset; ++i) {
            header.buffer.put((byte)0);
        }
        header.buffer.putInt(arraySize);
        return header;
    }

    private OCLByteBuffer buildArrayHeaderBatch(long arraySize) {
        OCLByteBuffer header = this.getArrayHeader();
        for (int i = 0; i < this.arrayLengthOffset; ++i) {
            header.buffer.put((byte)0);
        }
        header.buffer.putInt((int)arraySize);
        return header;
    }

    public int enqueueRead(long executionPlanId, Object value, long hostOffset, int[] events, boolean useDeps) {
        T array = this.cast(value);
        if (array == null) {
            throw new TornadoRuntimeException("[ERROR] output data is NULL");
        }
        int returnEvent = this.enqueueReadArrayData(executionPlanId, this.toBuffer(), (long)this.arrayHeaderSize + this.bufferOffset, this.bufferSize - (long)this.arrayHeaderSize, array, hostOffset, (int[])(useDeps ? events : null));
        return useDeps ? returnEvent : -1;
    }

    protected abstract int enqueueReadArrayData(long var1, long var3, long var5, long var7, T var9, long var10, int[] var12);

    public List<Integer> enqueueWrite(long executionPlanId, Object value, long batchSize, long hostOffset, int[] events, boolean useDeps) {
        T array = this.cast(value);
        if (array == null) {
            throw new TornadoRuntimeException("ERROR] Data to be copied is NULL");
        }
        ArrayList<Integer> listEvents = new ArrayList<Integer>();
        int headerEvent = batchSize <= 0L ? this.buildArrayHeader(Array.getLength(array)).enqueueWrite(executionPlanId, (int[])(useDeps ? events : null)) : this.buildArrayHeaderBatch(batchSize).enqueueWrite(executionPlanId, (int[])(useDeps ? events : null));
        int returnEvent = this.enqueueWriteArrayData(executionPlanId, this.toBuffer(), (long)this.arrayHeaderSize + this.bufferOffset, this.bufferSize - (long)this.arrayHeaderSize, array, hostOffset, (int[])(useDeps ? events : null));
        listEvents.add(headerEvent);
        listEvents.add(returnEvent);
        return listEvents;
    }

    protected abstract int enqueueWriteArrayData(long var1, long var3, long var5, long var7, T var9, long var10, int[] var12);

    private OCLByteBuffer getArrayHeader() {
        OCLByteBuffer header = new OCLByteBuffer(this.deviceContext, this.bufferId, this.bufferOffset, this.arrayHeaderSize);
        header.buffer.clear();
        return header;
    }

    private OCLByteBuffer prepareArrayHeader() {
        OCLByteBuffer header = this.getArrayHeader();
        header.buffer.position(header.buffer.capacity());
        return header;
    }

    public void read(long executionPlanId, Object value) {
        this.read(executionPlanId, value, 0L, 0L, null, false);
    }

    public int read(long executionPlanId, Object value, long hostOffset, long partialReadSize, int[] events, boolean useDeps) {
        T array = this.cast(value);
        if (array == null) {
            throw new TornadoRuntimeException("[ERROR] output data is NULL");
        }
        long numBytes = this.getSizeSubRegionSize() > 0L ? this.getSizeSubRegionSize() : this.bufferSize - (long)this.arrayHeaderSize;
        return this.readArrayData(executionPlanId, this.toBuffer(), (long)this.arrayHeaderSize + this.bufferOffset, numBytes, array, hostOffset, (int[])(useDeps ? events : null));
    }

    protected abstract int readArrayData(long var1, long var3, long var5, long var7, T var9, long var10, int[] var12);

    public long sizeOf(T array) {
        return (long)this.arrayHeaderSize + (long)Array.getLength(array) * (long)this.kind.getByteCount();
    }

    private long sizeOfBatch(long batchSize) {
        return (long)this.arrayHeaderSize + batchSize;
    }

    public long toBuffer() {
        return this.bufferId;
    }

    public void setBuffer(XPUBuffer.XPUBufferWrapper bufferWrapper) {
        this.bufferId = bufferWrapper.buffer;
        this.bufferOffset = bufferWrapper.bufferOffset;
        bufferWrapper.bufferOffset += this.size();
    }

    public long getBufferOffset() {
        return this.bufferOffset;
    }

    public String toString() {
        return String.format("buffer<%s> %s", this.kind.getJavaName(), RuntimeUtilities.humanReadableByteCount((long)this.bufferSize, (boolean)true));
    }

    private boolean validateArrayHeader(long executionPlanId, T array) {
        boolean valid;
        OCLByteBuffer header = this.prepareArrayHeader();
        header.read(executionPlanId);
        int numElements = header.getInt(this.arrayLengthOffset);
        boolean bl = valid = numElements == Array.getLength(array);
        if (!valid) {
            this.logger.fatal("Array: expected=%d, got=%d", new Object[]{Array.getLength(array), numElements});
            header.dump(8);
        }
        return valid;
    }

    public void write(long executionPlanId, Object value) {
        T array = this.cast(value);
        if (array == null) {
            throw new TornadoRuntimeException("[ERROR] data is NULL");
        }
        this.buildArrayHeader(Array.getLength(array)).write(executionPlanId);
        this.writeArrayData(executionPlanId, this.toBuffer(), (long)this.arrayHeaderSize + this.bufferOffset, this.bufferSize - (long)this.arrayHeaderSize, array, 0L, null);
    }

    protected abstract void writeArrayData(long var1, long var3, long var5, long var7, T var9, long var10, int[] var12);

    public long getSizeSubRegionSize() {
        return this.setSubRegionSize;
    }

    public void setSizeSubRegion(long batchSize) {
        this.setSubRegionSize = batchSize;
    }

    public void mapOnDeviceMemoryRegion(long executionPlanId, XPUBuffer srcPointer, long offset) {
        throw new TornadoRuntimeException("[ERROR] not implemented");
    }
}

