/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.mm;

import java.lang.reflect.Field;
import java.util.List;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class FieldBuffer {
    private final Field field;
    private final XPUBuffer objectBuffer;
    private final TornadoLogger logger;

    public FieldBuffer(Field field, XPUBuffer objectBuffer) {
        this.objectBuffer = objectBuffer;
        this.field = field;
        this.logger = new TornadoLogger(this.getClass());
    }

    public int enqueueRead(long executionPlanId, Object ref, int[] events, boolean useDeps) {
        if (TornadoOptions.DEBUG) {
            this.logger.trace("fieldBuffer: enqueueRead* - field=%s, parent=0x%x, child=0x%x", new Object[]{this.field, ref.hashCode(), this.getFieldValue(ref).hashCode()});
        }
        return useDeps ? this.objectBuffer.enqueueRead(executionPlanId, this.getFieldValue(ref), 0L, (int[])(useDeps ? events : null), useDeps) : -1;
    }

    public List<Integer> enqueueWrite(long executionPlanId, Object ref, int[] events, boolean useDeps) {
        if (TornadoOptions.DEBUG) {
            this.logger.trace("fieldBuffer: enqueueWrite* - field=%s, parent=0x%x, child=0x%x", new Object[]{this.field, ref.hashCode(), this.getFieldValue(ref).hashCode()});
        }
        return useDeps ? this.objectBuffer.enqueueWrite(executionPlanId, this.getFieldValue(ref), 0L, 0L, (int[])(useDeps ? events : null), useDeps) : null;
    }

    private Object getFieldValue(Object container) {
        Object value = null;
        try {
            value = this.field.get(container);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.logger.warn("Illegal access to field: name=%s, object=0x%x", new Object[]{this.field.getName(), container.hashCode()});
        }
        return value;
    }

    public void read(long executionPlanId, Object ref) {
        this.read(executionPlanId, ref, null, false);
    }

    public int read(long executionPlanId, Object ref, int[] events, boolean useDeps) {
        if (TornadoOptions.DEBUG) {
            this.logger.debug("fieldBuffer: read - field=%s, parent=0x%x, child=0x%x", new Object[]{this.field, ref.hashCode(), this.getFieldValue(ref).hashCode()});
        }
        return this.objectBuffer.read(executionPlanId, this.getFieldValue(ref), 0L, 0L, events, useDeps);
    }

    public void write(long executionPlanId, Object ref) {
        if (TornadoOptions.DEBUG) {
            this.logger.trace("fieldBuffer: write - field=%s, parent=0x%x, child=0x%x", new Object[]{this.field, ref.hashCode(), this.getFieldValue(ref).hashCode()});
        }
        this.objectBuffer.write(executionPlanId, this.getFieldValue(ref));
    }

    public long size() {
        return this.objectBuffer.size();
    }

    void setBuffer(XPUBuffer.XPUBufferWrapper bufferWrapper) {
        this.objectBuffer.setBuffer(bufferWrapper);
    }

    long getBufferOffset() {
        return this.objectBuffer.getBufferOffset();
    }
}

