/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.snippets;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.drivers.opencl.builtins.OpenCLIntrinsics;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.GlobalThreadSizeNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLIntBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.snippets.TornadoSnippetTypeInference;
import uk.ac.manchester.tornado.runtime.graal.nodes.StoreAtomicIndexedNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoReduceAddNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoReduceMulNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.WriteAtomicNode;

public class ReduceGPUSnippets
implements Snippets {
    private static int LOCAL_WORK_GROUP_SIZE = 223;

    @Snippet
    public static void partialReduceIntAdd(int[] inputArray, int[] outputArray, int gidx) {
        int[] localArray = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] + localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceIntAddCarrierValue(int[] inputArray, int[] outputArray, int gidx, int value) {
        int[] localArray = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        localArray[localIdx] = value;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] + localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceLongAdd(long[] inputArray, long[] outputArray, int gidx) {
        long[] localArray = (long[])NewArrayNode.newUninitializedArray(Long.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] + localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceLongAddCarrierValue(long[] inputArray, long[] outputArray, int gidx, long value) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int myID = localIdx + localGroupSize * groupID;
        inputArray[myID] = value;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = myID;
            inputArray[n] = inputArray[n] + inputArray[myID + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = inputArray[myID];
        }
    }

    @Snippet
    public static void partialReduceFloatAdd(float[] inputArray, float[] outputArray, int gidx) {
        float[] localArray = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] + localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceFloatAddCarrierValue(float[] inputArray, float[] outputArray, int gidx, float value) {
        float[] localArray = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int myID = localIdx + localGroupSize * groupID;
        localArray[localIdx] = value;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] + localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceDoubleAdd(double[] inputArray, double[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        double[] localArray = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] + localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceDoubleAddCarrierValue(double[] inputArray, double[] outputArray, int gidx, double value) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        double[] localArray = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = value;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] + localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceIntMult(int[] inputArray, int[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int[] localArray = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] * localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceIntMultCarrierValue(int[] inputArray, int[] outputArray, int gidx, int value) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int[] localArray = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = value;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] * localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceLongMult(long[] inputArray, long[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        long[] localArray = (long[])NewArrayNode.newUninitializedArray(Long.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] * localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceLongMultCarrierValue(long[] inputArray, long[] outputArray, int gidx, long value) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int myID = localIdx + localGroupSize * groupID;
        inputArray[myID] = value;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = myID;
            inputArray[n] = inputArray[n] * inputArray[myID + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = inputArray[myID];
        }
    }

    @Snippet
    public static void partialReduceFloatMult(float[] inputArray, float[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        float[] localArray = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] * localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceFloatMultCarrierValue(float[] inputArray, float[] outputArray, int gidx, float value) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        float[] localArray = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = value;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] * localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceDoubleMult(double[] inputArray, double[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        double[] localArray = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] * localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceDoubleMultCarrierValue(double[] inputArray, double[] outputArray, int gidx, double value) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        double[] localArray = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = value;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localArray[n] = localArray[n] * localArray[localIdx + stride];
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceIntMax(int[] inputArray, int[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int[] localArray = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.max((int)localArray[localIdx], (int)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceIntMaxCarrierValue(int[] inputArray, int[] outputArray, int gidx, int extra) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int[] localArray = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = extra;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.max((int)localArray[localIdx], (int)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceLongMax(long[] inputArray, long[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        long[] localArray = (long[])NewArrayNode.newUninitializedArray(Long.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.max((long)localArray[localIdx], (long)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceLongMaxCarrierValue(long[] inputArray, long[] outputArray, int gidx, long extra) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        long[] localArray = (long[])NewArrayNode.newUninitializedArray(Long.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = extra;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.max((long)localArray[localIdx], (long)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceFloatMax(float[] inputArray, float[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        float[] localArray = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.max((float)localArray[localIdx], (float)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceFloatMaxCarrierValue(float[] inputArray, float[] outputArray, int gidx, float extra) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        float[] localArray = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = extra;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.max((float)localArray[localIdx], (float)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceDoubleMax(double[] inputArray, double[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        double[] localArray = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.max((double)localArray[localIdx], (double)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceDoubleMaxCarrierValue(double[] inputArray, double[] outputArray, int gidx, double extra) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        double[] localArray = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = extra;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.max((double)localArray[localIdx], (double)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceIntMin(int[] inputArray, int[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int[] localArray = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.min((int)localArray[localIdx], (int)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceIntMinCarrierValue(int[] inputArray, int[] outputArray, int gidx, int extra) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        int[] localArray = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = extra;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.min((int)localArray[localIdx], (int)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceLongMin(long[] inputArray, long[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        long[] localArray = (long[])NewArrayNode.newUninitializedArray(Long.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.min((long)localArray[localIdx], (long)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceLongMinCarrierValue(long[] inputArray, long[] outputArray, int gidx, long extra) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        long[] localArray = (long[])NewArrayNode.newUninitializedArray(Long.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = extra;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.min((long)localArray[localIdx], (long)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceFloatMin(float[] inputArray, float[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        float[] localArray = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.min((float)localArray[localIdx], (float)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceFloatMinCarrierValue(float[] inputArray, float[] outputArray, int gidx, float extra) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        float[] localArray = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = extra;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.min((float)localArray[localIdx], (float)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceDoubleMin(double[] inputArray, double[] outputArray, int gidx) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        double[] localArray = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = inputArray[gidx];
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.min((double)localArray[localIdx], (double)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    @Snippet
    public static void partialReduceDoubleMinCarrierValue(double[] inputArray, double[] outputArray, int gidx, double extra) {
        int localIdx = OpenCLIntrinsics.get_local_id(0);
        int localGroupSize = OpenCLIntrinsics.get_local_size(0);
        int groupID = OpenCLIntrinsics.get_group_id(0);
        double[] localArray = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, (int)LOCAL_WORK_GROUP_SIZE);
        localArray[localIdx] = extra;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            OpenCLIntrinsics.localBarrier();
            if (localIdx >= stride) continue;
            localArray[localIdx] = TornadoMath.min((double)localArray[localIdx], (double)localArray[localIdx + stride]);
        }
        OpenCLIntrinsics.globalBarrier();
        if (localIdx == 0) {
            outputArray[groupID + 1] = localArray[0];
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates
    implements TornadoSnippetTypeInference {
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceIntSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceIntAdd");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceIntSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceIntAddCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceLongSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceLongAdd");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceLongSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceLongAddCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceAddFloatSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceFloatAdd");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceAddFloatSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceFloatAddCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceAddDoubleSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceDoubleAdd");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceAddDoubleSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceDoubleAddCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceIntMultSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceIntMult");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceIntMultSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceIntMultCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceLongMultSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceLongMult");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceLongMultSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceLongMultCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceFloatMultSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceFloatMult");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceFloatMultSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceFloatMultCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceDoubleMultSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceDoubleMult");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceDoubleMultSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceDoubleMultCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceIntMaxSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceIntMax");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceIntMaxSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceIntMaxCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceLongMaxSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceLongMax");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceLongMaxSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceLongMaxCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceMaxFloatSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceFloatMax");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceMaxFloatSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceFloatMaxCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceMaxDoubleSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceDoubleMax");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceMaxDoubleSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceDoubleMaxCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceIntMinSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceIntMin");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceIntMinSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceIntMinCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceLongMinSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceLongMin");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceLongMinSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceLongMinCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceMinFloatSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceFloatMin");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceMinFloatSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceFloatMinCarrierValue");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceMinDoubleSnippet = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceDoubleMin");
        private final Tuple2<Class<? extends ReduceGPUSnippets>, String> partialReduceMinDoubleSnippetCarrierValue = new Tuple2<Class<ReduceGPUSnippets>, String>(ReduceGPUSnippets.class, "partialReduceDoubleMinCarrierValue");
        Providers providers;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.providers = providers;
        }

        private SnippetTemplate.SnippetInfo snippet(Tuple2<Class<? extends ReduceGPUSnippets>, String> tuple2) {
            return this.snippet(this.providers, (Class)tuple2.t0, (String)tuple2.t1, new LocationIdentity[0]);
        }

        private SnippetTemplate.SnippetInfo getSnippetFromOCLBinaryNodeInteger(OCLIntBinaryIntrinsicNode value, ValueNode extra) {
            switch (value.operation()) {
                case MAX: {
                    return extra == null ? this.snippet(this.partialReduceIntMaxSnippet) : this.snippet(this.partialReduceIntMaxSnippetCarrierValue);
                }
                case MIN: {
                    return extra == null ? this.snippet(this.partialReduceIntMinSnippet) : this.snippet(this.partialReduceIntMinSnippetCarrierValue);
                }
            }
            throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
        }

        private SnippetTemplate.SnippetInfo getSnippetFromOCLBinaryNodeLong(OCLIntBinaryIntrinsicNode value, ValueNode extra) {
            switch (value.operation()) {
                case MAX: {
                    return extra == null ? this.snippet(this.partialReduceLongMaxSnippet) : this.snippet(this.partialReduceLongMaxSnippetCarrierValue);
                }
                case MIN: {
                    return extra == null ? this.snippet(this.partialReduceLongMinSnippet) : this.snippet(this.partialReduceLongMinSnippetCarrierValue);
                }
            }
            throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
        }

        @Override
        public SnippetTemplate.SnippetInfo inferIntSnippet(ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet;
            if (value instanceof TornadoReduceAddNode) {
                snippet = extra == null ? this.snippet(this.partialReduceIntSnippet) : this.snippet(this.partialReduceIntSnippetCarrierValue);
            } else if (value instanceof TornadoReduceMulNode) {
                snippet = extra == null ? this.snippet(this.partialReduceIntMultSnippet) : this.snippet(this.partialReduceIntMultSnippetCarrierValue);
            } else if (value instanceof OCLIntBinaryIntrinsicNode) {
                OCLIntBinaryIntrinsicNode op = (OCLIntBinaryIntrinsicNode)value;
                snippet = this.getSnippetFromOCLBinaryNodeInteger(op, extra);
            } else {
                throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
            }
            return snippet;
        }

        @Override
        public SnippetTemplate.SnippetInfo inferLongSnippet(ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet;
            if (value instanceof TornadoReduceAddNode) {
                snippet = extra == null ? this.snippet(this.partialReduceLongSnippet) : this.snippet(this.partialReduceLongSnippetCarrierValue);
            } else if (value instanceof TornadoReduceMulNode) {
                snippet = extra == null ? this.snippet(this.partialReduceLongMultSnippet) : this.snippet(this.partialReduceLongMultSnippetCarrierValue);
            } else if (value instanceof OCLIntBinaryIntrinsicNode) {
                OCLIntBinaryIntrinsicNode op = (OCLIntBinaryIntrinsicNode)value;
                snippet = this.getSnippetFromOCLBinaryNodeLong(op, extra);
            } else {
                throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
            }
            return snippet;
        }

        private SnippetTemplate.SnippetInfo getSnippetFromOCLBinaryNodeInteger(OCLFPBinaryIntrinsicNode value, ValueNode extra) {
            switch (value.operation()) {
                case FMAX: {
                    return extra == null ? this.snippet(this.partialReduceMaxFloatSnippet) : this.snippet(this.partialReduceMaxFloatSnippetCarrierValue);
                }
                case FMIN: {
                    return extra == null ? this.snippet(this.partialReduceMinFloatSnippet) : this.snippet(this.partialReduceMinFloatSnippetCarrierValue);
                }
            }
            throw new RuntimeException("OCLFPBinaryIntrinsicNode operation not supported yet");
        }

        @Override
        public SnippetTemplate.SnippetInfo inferFloatSnippet(ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet;
            if (value instanceof TornadoReduceAddNode) {
                snippet = extra == null ? this.snippet(this.partialReduceAddFloatSnippet) : this.snippet(this.partialReduceAddFloatSnippetCarrierValue);
            } else if (value instanceof TornadoReduceMulNode) {
                snippet = extra == null ? this.snippet(this.partialReduceFloatMultSnippet) : this.snippet(this.partialReduceFloatMultSnippetCarrierValue);
            } else if (value instanceof OCLFPBinaryIntrinsicNode) {
                snippet = this.getSnippetFromOCLBinaryNodeInteger((OCLFPBinaryIntrinsicNode)value, extra);
            } else {
                throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
            }
            return snippet;
        }

        private SnippetTemplate.SnippetInfo getSnippetFromOCLBinaryNodeDouble(OCLFPBinaryIntrinsicNode value, ValueNode extra) {
            switch (value.operation()) {
                case FMAX: {
                    return extra == null ? this.snippet(this.partialReduceMaxDoubleSnippet) : this.snippet(this.partialReduceMaxDoubleSnippetCarrierValue);
                }
                case FMIN: {
                    return extra == null ? this.snippet(this.partialReduceMinDoubleSnippet) : this.snippet(this.partialReduceMinDoubleSnippetCarrierValue);
                }
            }
            throw new RuntimeException("OCLFPBinaryIntrinsicNode operation not supported yet");
        }

        @Override
        public SnippetTemplate.SnippetInfo inferDoubleSnippet(ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet = null;
            if (value instanceof TornadoReduceAddNode) {
                snippet = extra == null ? this.snippet(this.partialReduceAddDoubleSnippet) : this.snippet(this.partialReduceAddDoubleSnippetCarrierValue);
            } else if (value instanceof TornadoReduceMulNode) {
                snippet = extra == null ? this.snippet(this.partialReduceDoubleMultSnippet) : this.snippet(this.partialReduceDoubleMultSnippetCarrierValue);
            } else if (value instanceof OCLFPBinaryIntrinsicNode) {
                snippet = this.getSnippetFromOCLBinaryNodeDouble((OCLFPBinaryIntrinsicNode)value, extra);
            } else {
                throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
            }
            return snippet;
        }

        @Override
        public SnippetTemplate.SnippetInfo getSnippetInstance(JavaKind elementKind, ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet = null;
            if (elementKind == JavaKind.Int) {
                snippet = this.inferIntSnippet(value, extra);
            } else if (elementKind == JavaKind.Long) {
                snippet = this.inferLongSnippet(value, extra);
            } else if (elementKind == JavaKind.Float) {
                snippet = this.inferFloatSnippet(value, extra);
            } else if (elementKind == JavaKind.Double) {
                snippet = this.inferDoubleSnippet(value, extra);
            }
            return snippet;
        }

        public void lower(StoreAtomicIndexedNode storeAtomicIndexed, ValueNode globalId, GlobalThreadSizeNode globalSize, LoweringTool tool) {
            JavaKind elementKind = storeAtomicIndexed.elementKind();
            ValueNode value = storeAtomicIndexed.value();
            ValueNode extra = storeAtomicIndexed.getExtraOperation();
            SnippetTemplate.SnippetInfo snippet = this.getSnippetInstance(elementKind, value, extra);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, GraphState.GuardsStage.AFTER_FSA, tool.getLoweringStage());
            args.add("inputData", (Object)storeAtomicIndexed.getInputArray());
            args.add("outputArray", (Object)storeAtomicIndexed.array());
            args.add("gidx", (Object)globalId);
            if (extra != null) {
                args.add("value", (Object)extra);
            }
            SnippetTemplate template = this.template((CoreProviders)tool, (ValueNode)storeAtomicIndexed, args);
            template.instantiate(tool.getMetaAccess(), (FixedNode)storeAtomicIndexed, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(WriteAtomicNode writeAtomic, ValueNode globalId, GlobalThreadSizeNode globalSize, LoweringTool tool) {
            JavaKind elementKind = writeAtomic.getElementKind();
            ValueNode value = writeAtomic.value();
            ValueNode extra = writeAtomic.getExtraOperation();
            SnippetTemplate.SnippetInfo snippet = this.getSnippetInstance(elementKind, value, extra);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, GraphState.GuardsStage.AFTER_FSA, tool.getLoweringStage());
            args.add("inputData", (Object)writeAtomic.getInputArray());
            args.add("outputArray", (Object)writeAtomic.getOutArray());
            args.add("gidx", (Object)globalId);
            if (extra != null) {
                args.add("value", (Object)extra);
            }
            SnippetTemplate template = this.template((CoreProviders)tool, (ValueNode)writeAtomic, args);
            template.instantiate(tool.getMetaAccess(), (FixedNode)writeAtomic, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected static class Tuple2<T0, T1> {
        T0 t0;
        T1 t1;

        public Tuple2(T0 first, T1 second) {
            this.t0 = first;
            this.t1 = second;
        }

        public T0 f0() {
            return this.t0;
        }

        public T1 f1() {
            return this.t1;
        }
    }
}

