/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.snippets;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.drivers.opencl.builtins.OpenCLIntrinsics;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLIntBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.snippets.TornadoSnippetTypeInference;
import uk.ac.manchester.tornado.runtime.graal.nodes.StoreAtomicIndexedNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoReduceAddNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoReduceMulNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.WriteAtomicNode;

public class ReduceCPUSnippets
implements Snippets {
    @Snippet
    public static void partialReduceIntAdd(int[] inputArray, int[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] + inputArray[gidx];
        }
    }

    @Snippet
    public static void partialReduceIntAddCarrierValue(int[] inputArray, int[] outputArray, int gidx, int start, int globalID, int value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] + value;
        }
    }

    @Snippet
    public static void partialReduceIntMul(int[] inputArray, int[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] * inputArray[gidx];
        }
    }

    @Snippet
    public static void partialReduceIntMulCarrierValue(int[] inputArray, int[] outputArray, int gidx, int start, int globalID, int value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] * value;
        }
    }

    @Snippet
    public static void partialReduceIntMax(int[] inputArray, int[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.max((int)outputArray[globalID + 1], (int)inputArray[gidx]);
        }
    }

    @Snippet
    public static void partialReduceIntMaxCarrierValue(int[] inputArray, int[] outputArray, int gidx, int start, int globalID, int value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.max((int)outputArray[globalID + 1], (int)value);
        }
    }

    @Snippet
    public static void partialReduceIntMin(int[] inputArray, int[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.min((int)outputArray[globalID + 1], (int)inputArray[gidx]);
        }
    }

    @Snippet
    public static void partialReduceIntMinCarrierValue(int[] inputArray, int[] outputArray, int gidx, int start, int globalID, int value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.min((int)outputArray[globalID + 1], (int)value);
        }
    }

    @Snippet
    public static void partialReduceLongAdd(long[] inputArray, long[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] + inputArray[gidx];
        }
    }

    @Snippet
    public static void partialReduceLongAddCarrierValue(long[] inputArray, long[] outputArray, int gidx, int start, int globalID, long value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] + value;
        }
    }

    @Snippet
    public static void partialReduceLongMul(long[] inputArray, long[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] * inputArray[gidx];
        }
    }

    @Snippet
    public static void partialReduceLongMulCarrierValue(long[] inputArray, long[] outputArray, int gidx, int start, int globalID, long value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] * value;
        }
    }

    @Snippet
    public static void partialReduceLongMax(long[] inputArray, long[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.max((long)outputArray[globalID + 1], (long)inputArray[gidx]);
        }
    }

    @Snippet
    public static void partialReduceLongMaxCarrierValue(long[] inputArray, long[] outputArray, int gidx, int start, int globalID, long value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.max((long)outputArray[globalID + 1], (long)value);
        }
    }

    @Snippet
    public static void partialReduceLongMin(long[] inputArray, long[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.min((long)outputArray[globalID + 1], (long)inputArray[gidx]);
        }
    }

    @Snippet
    public static void partialReduceLongMinCarrierValue(long[] inputArray, long[] outputArray, int gidx, int start, int globalID, long value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.min((long)outputArray[globalID + 1], (long)value);
        }
    }

    @Snippet
    public static void partialReduceFloatAdd(float[] inputArray, float[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] + inputArray[gidx];
        }
    }

    @Snippet
    public static void partialReduceFloatAddCarrierValue(float[] inputArray, float[] outputArray, int gidx, int start, int globalID, float value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] + value;
        }
    }

    @Snippet
    public static void partialReduceFloatMul(float[] inputArray, float[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] * inputArray[gidx];
        }
    }

    @Snippet
    public static void partialReduceFloatMulCarrierValue(float[] inputArray, float[] outputArray, int gidx, int start, int globalID, float value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] * value;
        }
    }

    @Snippet
    public static void partialReduceFloatMax(float[] inputArray, float[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.max((float)outputArray[globalID + 1], (float)inputArray[gidx]);
        }
    }

    @Snippet
    public static void partialReduceFloatMaxCarrierValue(float[] inputArray, float[] outputArray, int gidx, int start, int globalID, float value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.max((float)outputArray[globalID + 1], (float)value);
        }
    }

    @Snippet
    public static void partialReduceFloatMin(float[] inputArray, float[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.min((float)outputArray[globalID + 1], (float)inputArray[gidx]);
        }
    }

    @Snippet
    public static void partialReduceFloatMinCarrierValue(float[] inputArray, float[] outputArray, int gidx, int start, int globalID, float value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.min((float)outputArray[globalID + 1], (float)value);
        }
    }

    @Snippet
    public static void partialReduceDoubleAdd(double[] inputArray, double[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] + inputArray[gidx];
        }
    }

    @Snippet
    public static void partialReduceDoubleAddCarrierValue(double[] inputArray, double[] outputArray, int gidx, int start, int globalID, double value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] + value;
        }
    }

    @Snippet
    public static void partialReduceDoubleMul(double[] inputArray, double[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] * inputArray[gidx];
        }
    }

    @Snippet
    public static void partialReduceDoubleMulCarrierValue(double[] inputArray, double[] outputArray, int gidx, int start, int globalID, double value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            int n = globalID + 1;
            outputArray[n] = outputArray[n] * value;
        }
    }

    @Snippet
    public static void partialReduceDoubleMax(double[] inputArray, double[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.max((double)outputArray[globalID + 1], (double)inputArray[gidx]);
        }
    }

    @Snippet
    public static void partialReduceDoubleMaxCarrierValue(double[] inputArray, double[] outputArray, int gidx, int start, int globalID, double value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.max((double)outputArray[globalID + 1], (double)value);
        }
    }

    @Snippet
    public static void partialReduceDoubleMin(double[] inputArray, double[] outputArray, int gidx, int start, int globalID) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.min((double)outputArray[globalID + 1], (double)inputArray[gidx]);
        }
    }

    @Snippet
    public static void partialReduceDoubleMinCarrierValue(double[] inputArray, double[] outputArray, int gidx, int start, int globalID, double value) {
        OpenCLIntrinsics.localBarrier();
        if (gidx >= start) {
            outputArray[globalID + 1] = TornadoMath.min((double)outputArray[globalID + 1], (double)value);
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates
    implements TornadoSnippetTypeInference {
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceAddIntSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceIntAdd");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMulIntSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceIntMulCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMaxIntSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceIntMax");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMaxIntSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceIntMaxCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMinIntSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceIntMin");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMinIntSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceIntMinCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceAddLongSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceLongAdd");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceAddLongSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceLongAddCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMulLongSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceLongMul");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMulLongSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceLongMulCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMaxLongSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceLongMax");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMaxLongSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceLongMaxCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMinLongSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceLongMin");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMinLongSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceLongMinCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceAddFloatSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceFloatAdd");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceAddFloatSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceFloatAddCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMulFloatSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceFloatMul");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMulFloatSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceFloatMulCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMaxFloatSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceFloatMax");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMaxFloatSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceFloatMaxCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMinFloatSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceFloatMin");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMinFloatSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceFloatMinCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceAddDoubleSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceDoubleAdd");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceAddDoubleSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceDoubleAddCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMulDoubleSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceDoubleMul");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMulDoubleSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceDoubleMulCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMaxDoubleSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceDoubleMax");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMaxDoubleSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceDoubleMaxCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMinDoubleSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceDoubleMin");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMinDoubleSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceDoubleMinCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceAddIntSnippetCarrierValue = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceIntAddCarrierValue");
        private final Tuple2<Class<? extends ReduceCPUSnippets>, String> partialReduceMulIntSnippet = new Tuple2<Class<ReduceCPUSnippets>, String>(ReduceCPUSnippets.class, "partialReduceIntMul");
        Providers providers;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.providers = providers;
        }

        private SnippetTemplate.SnippetInfo snippet(Tuple2<Class<? extends ReduceCPUSnippets>, String> tuple2) {
            return this.snippet(this.providers, (Class)tuple2.t0, (String)tuple2.t1, new LocationIdentity[0]);
        }

        private SnippetTemplate.SnippetInfo getSnippetFromOCLBinaryNodeInteger(OCLIntBinaryIntrinsicNode value, ValueNode extra) {
            switch (value.operation()) {
                case MAX: {
                    return extra == null ? this.snippet(this.partialReduceMaxIntSnippet) : this.snippet(this.partialReduceMaxIntSnippetCarrierValue);
                }
                case MIN: {
                    return extra == null ? this.snippet(this.partialReduceMinIntSnippet) : this.snippet(this.partialReduceMinIntSnippetCarrierValue);
                }
            }
            throw new RuntimeException("OCLFPBinaryIntrinsicNode operation not supported yet");
        }

        private SnippetTemplate.SnippetInfo getSnippetFromOCLBinaryNodeLong(OCLIntBinaryIntrinsicNode value, ValueNode extra) {
            switch (value.operation()) {
                case MAX: {
                    return extra == null ? this.snippet(this.partialReduceMaxLongSnippet) : this.snippet(this.partialReduceMaxLongSnippetCarrierValue);
                }
                case MIN: {
                    return extra == null ? this.snippet(this.partialReduceMinLongSnippet) : this.snippet(this.partialReduceMinLongSnippetCarrierValue);
                }
            }
            throw new RuntimeException("OCLFPBinaryIntrinsicNode operation not supported yet");
        }

        @Override
        public SnippetTemplate.SnippetInfo inferIntSnippet(ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet = null;
            if (value instanceof TornadoReduceAddNode) {
                snippet = extra == null ? this.snippet(this.partialReduceAddIntSnippet) : this.snippet(this.partialReduceAddIntSnippetCarrierValue);
            } else if (value instanceof TornadoReduceMulNode) {
                snippet = extra == null ? this.snippet(this.partialReduceMulIntSnippet) : this.snippet(this.partialReduceMulIntSnippetCarrierValue);
            } else if (value instanceof OCLIntBinaryIntrinsicNode) {
                snippet = this.getSnippetFromOCLBinaryNodeInteger((OCLIntBinaryIntrinsicNode)value, extra);
            } else {
                throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
            }
            return snippet;
        }

        @Override
        public SnippetTemplate.SnippetInfo inferLongSnippet(ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet = null;
            if (value instanceof TornadoReduceAddNode) {
                snippet = extra == null ? this.snippet(this.partialReduceAddLongSnippet) : this.snippet(this.partialReduceAddLongSnippetCarrierValue);
            } else if (value instanceof TornadoReduceMulNode) {
                snippet = extra == null ? this.snippet(this.partialReduceMulLongSnippet) : this.snippet(this.partialReduceMulLongSnippetCarrierValue);
            } else if (value instanceof OCLIntBinaryIntrinsicNode) {
                snippet = this.getSnippetFromOCLBinaryNodeLong((OCLIntBinaryIntrinsicNode)value, extra);
            } else {
                throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
            }
            return snippet;
        }

        private SnippetTemplate.SnippetInfo getSnippetFromOCLBinaryNode(OCLFPBinaryIntrinsicNode value, ValueNode extra) {
            switch (value.operation()) {
                case FMAX: {
                    return extra == null ? this.snippet(this.partialReduceMaxFloatSnippet) : this.snippet(this.partialReduceMaxFloatSnippetCarrierValue);
                }
                case FMIN: {
                    return extra == null ? this.snippet(this.partialReduceMinFloatSnippet) : this.snippet(this.partialReduceMinFloatSnippetCarrierValue);
                }
            }
            throw new RuntimeException("OCLFPBinaryIntrinsicNode operation not supported yet");
        }

        @Override
        public SnippetTemplate.SnippetInfo inferFloatSnippet(ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet = null;
            if (value instanceof TornadoReduceAddNode) {
                snippet = extra == null ? this.snippet(this.partialReduceAddFloatSnippet) : this.snippet(this.partialReduceAddFloatSnippetCarrierValue);
            } else if (value instanceof TornadoReduceMulNode) {
                snippet = extra == null ? this.snippet(this.partialReduceMulFloatSnippet) : this.snippet(this.partialReduceMulFloatSnippetCarrierValue);
            } else if (value instanceof OCLFPBinaryIntrinsicNode) {
                snippet = this.getSnippetFromOCLBinaryNode((OCLFPBinaryIntrinsicNode)value, extra);
            } else {
                throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
            }
            return snippet;
        }

        private SnippetTemplate.SnippetInfo getSnippetFromOCLBinaryNodeDouble(OCLFPBinaryIntrinsicNode value, ValueNode extra) {
            switch (value.operation()) {
                case FMAX: {
                    return extra == null ? this.snippet(this.partialReduceMaxDoubleSnippet) : this.snippet(this.partialReduceMaxDoubleSnippetCarrierValue);
                }
                case FMIN: {
                    return extra == null ? this.snippet(this.partialReduceMinDoubleSnippet) : this.snippet(this.partialReduceMinDoubleSnippetCarrierValue);
                }
            }
            throw new RuntimeException("OCLFPBinaryIntrinsicNode operation not supported yet");
        }

        @Override
        public SnippetTemplate.SnippetInfo inferDoubleSnippet(ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet = null;
            if (value instanceof TornadoReduceAddNode) {
                snippet = extra == null ? this.snippet(this.partialReduceAddDoubleSnippet) : this.snippet(this.partialReduceAddDoubleSnippetCarrierValue);
            } else if (value instanceof TornadoReduceMulNode) {
                snippet = extra == null ? this.snippet(this.partialReduceMulDoubleSnippet) : this.snippet(this.partialReduceMulDoubleSnippetCarrierValue);
            } else if (value instanceof OCLFPBinaryIntrinsicNode) {
                snippet = this.getSnippetFromOCLBinaryNodeDouble((OCLFPBinaryIntrinsicNode)value, extra);
            } else {
                throw new RuntimeException("Reduce Operation no supported yet: snippet not installed");
            }
            return snippet;
        }

        @Override
        public SnippetTemplate.SnippetInfo getSnippetInstance(JavaKind elementKind, ValueNode value, ValueNode extra) {
            SnippetTemplate.SnippetInfo snippet;
            if (elementKind == JavaKind.Int) {
                snippet = this.inferIntSnippet(value, extra);
            } else if (elementKind == JavaKind.Long) {
                snippet = this.inferLongSnippet(value, extra);
            } else if (elementKind == JavaKind.Float) {
                snippet = this.inferFloatSnippet(value, extra);
            } else if (elementKind == JavaKind.Double) {
                snippet = this.inferDoubleSnippet(value, extra);
            } else {
                throw new RuntimeException("Data type not supported");
            }
            return snippet;
        }

        public void lower(StoreAtomicIndexedNode storeAtomicIndexed, ValueNode threadId, ValueNode globalID, ValueNode startIndexNode, LoweringTool tool) {
            JavaKind elementKind = storeAtomicIndexed.elementKind();
            ValueNode value = storeAtomicIndexed.value();
            ValueNode extra = storeAtomicIndexed.getExtraOperation();
            SnippetTemplate.SnippetInfo snippet = this.getSnippetInstance(elementKind, value, extra);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, GraphState.GuardsStage.AFTER_FSA, tool.getLoweringStage());
            args.add("inputData", (Object)storeAtomicIndexed.getInputArray());
            args.add("outputArray", (Object)storeAtomicIndexed.array());
            args.add("gidx", (Object)threadId);
            args.add("start", (Object)startIndexNode);
            args.add("globalID", (Object)globalID);
            if (extra != null) {
                args.add("value", (Object)extra);
            }
            this.template((CoreProviders)tool, (ValueNode)storeAtomicIndexed, args).instantiate(tool.getMetaAccess(), (FixedNode)storeAtomicIndexed, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(WriteAtomicNode writeAtomic, ValueNode threadId, ValueNode globalID, ValueNode startIndexNode, LoweringTool tool) {
            JavaKind elementKind = writeAtomic.getElementKind();
            ValueNode value = writeAtomic.value();
            ValueNode extra = writeAtomic.getExtraOperation();
            SnippetTemplate.SnippetInfo snippet = this.getSnippetInstance(elementKind, value, extra);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, GraphState.GuardsStage.AFTER_FSA, tool.getLoweringStage());
            args.add("inputData", (Object)writeAtomic.getInputArray());
            args.add("outputArray", (Object)writeAtomic.getOutArray());
            args.add("gidx", (Object)threadId);
            args.add("start", (Object)startIndexNode);
            args.add("globalID", (Object)globalID);
            if (extra != null) {
                args.add("value", (Object)extra);
            }
            this.template((CoreProviders)tool, (ValueNode)writeAtomic, args).instantiate(tool.getMetaAccess(), (FixedNode)writeAtomic, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected static class Tuple2<T0, T1> {
        T0 t0;
        T1 t1;

        public Tuple2(T0 first, T1 second) {
            this.t0 = first;
            this.t1 = second;
        }

        public T0 f0() {
            return this.t0;
        }

        public T1 f1() {
            return this.t1;
        }
    }
}

