/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Optional;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.RawConstant;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLAddressNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorValueNode;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.nodes.VectorHalfRead;

public class TornadoHalfFloatVectorOffset
extends Phase {
    private static int HALF_SIZE = 2;
    private static long HEADER_SIZE = TornadoNativeArray.ARRAY_HEADER;
    private static String object_offset;

    public TornadoHalfFloatVectorOffset() {
        object_offset = TornadoOptions.coopsUsed() ? "2" : "3";
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        for (ReadNode readNode : graph.getNodes().filter(ReadNode.class)) {
            if (!readNode.successors().filter(VectorHalfRead.class).isNotEmpty()) continue;
            VectorHalfRead vectorHalfRead = (VectorHalfRead)readNode.successors().filter(VectorHalfRead.class).first();
            TornadoHalfFloatVectorOffset.replaceReadOffset(readNode, vectorHalfRead, graph);
            TornadoHalfFloatVectorOffset.deleteFixed((Node)vectorHalfRead);
        }
        for (WriteNode writeNode : graph.getNodes().filter(WriteNode.class)) {
            if (!(writeNode.value() instanceof VectorValueNode) || !((VectorValueNode)writeNode.value()).getOCLKind().isHalf()) continue;
            TornadoHalfFloatVectorOffset.replaceWriteOffset(writeNode, graph);
        }
    }

    private static void replaceReadOffset(ReadNode readNode, VectorHalfRead vectorHalfRead, StructuredGraph graph) {
        LeftShiftNode leftShiftNode;
        ConstantNode currentOffset;
        OCLAddressNode oclAddressNode = (OCLAddressNode)readNode.getAddress();
        ValueNode index = oclAddressNode.getIndex();
        if (index instanceof ConstantNode) {
            int vectorReadIndex = vectorHalfRead.getIndex();
            if (vectorReadIndex != -1) {
                RawConstant shortOffset = new RawConstant((long)(vectorReadIndex * HALF_SIZE) + HEADER_SIZE);
                ConstantNode shortOffsetNode = new ConstantNode((Constant)shortOffset, StampFactory.forKind((JavaKind)JavaKind.Int));
                graph.addWithoutUnique((Node)shortOffsetNode);
                oclAddressNode.replaceFirstInput((Node)index, (Node)shortOffsetNode);
                if (index.usages().isEmpty()) {
                    index.safeDelete();
                }
            }
        } else if (index.inputs().filter(LeftShiftNode.class).isNotEmpty() && (currentOffset = (ConstantNode)(leftShiftNode = (LeftShiftNode)index.inputs().filter(LeftShiftNode.class).first()).inputs().filter(ConstantNode.class).first()).getValue().toValueString().equals(object_offset)) {
            RawConstant shortOffset = new RawConstant(1L);
            ConstantNode shortOffsetNode = new ConstantNode((Constant)shortOffset, StampFactory.forKind((JavaKind)JavaKind.Int));
            graph.addWithoutUnique((Node)shortOffsetNode);
            leftShiftNode.replaceFirstInput((Node)currentOffset, (Node)shortOffsetNode);
            if (currentOffset.usages().isEmpty()) {
                currentOffset.safeDelete();
            }
        }
    }

    private static void replaceWriteOffset(WriteNode writeNode, StructuredGraph graph) {
        LeftShiftNode leftShiftNode;
        ConstantNode currentOffset;
        OCLAddressNode oclAddressNode = (OCLAddressNode)writeNode.getAddress();
        ValueNode index = oclAddressNode.getIndex();
        if (index.inputs().filter(LeftShiftNode.class).isNotEmpty() && (currentOffset = (ConstantNode)(leftShiftNode = (LeftShiftNode)index.inputs().filter(LeftShiftNode.class).first()).inputs().filter(ConstantNode.class).first()).getValue().toValueString().equals(object_offset)) {
            RawConstant shortOffset = new RawConstant(1L);
            ConstantNode shortOffsetNode = new ConstantNode((Constant)shortOffset, StampFactory.forKind((JavaKind)JavaKind.Int));
            graph.addWithoutUnique((Node)shortOffsetNode);
            leftShiftNode.replaceFirstInput((Node)currentOffset, (Node)shortOffsetNode);
            if (currentOffset.usages().isEmpty()) {
                currentOffset.safeDelete();
            }
        }
    }

    private static void deleteFixed(Node n) {
        Node pred = n.predecessor();
        Node suc = n.successors().first();
        n.replaceFirstSuccessor(suc, null);
        n.replaceAtPredecessor(suc);
        pred.replaceFirstSuccessor(n, suc);
        for (Node us : n.usages()) {
            n.removeUsage(us);
        }
        n.clearInputs();
        n.safeDelete();
    }
}

