/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.ArrayList;
import java.util.Optional;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.RawConstant;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.api.internal.annotations.HalfType;
import uk.ac.manchester.tornado.drivers.opencl.graal.HalfFloatStamp;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.AddHalfNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.DivHalfNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.HalfFloatConstantNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.MultHalfNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLConvertFloatToHalf;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLConvertHalfToFloat;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.ReadHalfFloatNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.SubHalfNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.WriteHalfFloatNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.LoadIndexedVectorNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorAddHalfNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorLoadElementNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorMultHalfNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorSubHalfNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorValueNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.AddHalfFloatNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.DivHalfFloatNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.HalfFloatPlaceholder;
import uk.ac.manchester.tornado.runtime.graal.nodes.MultHalfFloatNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.NewHalfFloatInstance;
import uk.ac.manchester.tornado.runtime.graal.nodes.SubHalfFloatNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.VectorHalfRead;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoHighTierContext;

public class TornadoHalfFloatReplacement
extends BasePhase<TornadoHighTierContext> {
    private static void replaceFieldAccess(LoadFieldNode loadFieldNode) {
        if (loadFieldNode.predecessor() instanceof FixedGuardNode) {
            FixedGuardNode fixedGuardNode = (FixedGuardNode)loadFieldNode.predecessor();
            TornadoHalfFloatReplacement.deleteFixed((Node)fixedGuardNode);
        }
        ArrayList<Node> nodesToBeDeleted = new ArrayList<Node>();
        nodesToBeDeleted.add((Node)loadFieldNode);
        Node replacement = TornadoHalfFloatReplacement.identifyFieldReplacement((Node)loadFieldNode.object(), nodesToBeDeleted);
        loadFieldNode.replaceAtUsages(replacement);
        for (Node toBeDeleted : nodesToBeDeleted) {
            if (toBeDeleted instanceof FixedNode) {
                TornadoHalfFloatReplacement.deleteFixed(toBeDeleted);
                continue;
            }
            toBeDeleted.safeDelete();
        }
    }

    private static Node identifyFieldReplacement(Node input, ArrayList<Node> nodesToBeDeleted) {
        if (input instanceof ReadHalfFloatNode || input instanceof ValuePhiNode) {
            return input;
        }
        if (input instanceof PiNode || input instanceof IsNullNode) {
            nodesToBeDeleted.add(input);
        }
        Node replacement = null;
        for (Node iterativeInputs : input.inputs()) {
            replacement = TornadoHalfFloatReplacement.identifyFieldReplacement(iterativeInputs, nodesToBeDeleted);
            if (replacement == null) continue;
            return replacement;
        }
        return replacement;
    }

    private static ValueNode getHalfFloatValue(ValueNode halfFloatValue, StructuredGraph graph) {
        JavaReadNode javaReadNode;
        if (halfFloatValue instanceof ConstantNode) {
            ConstantNode floatValue = (ConstantNode)halfFloatValue;
            HalfFloatConstantNode halfFloatConstantNode = new HalfFloatConstantNode(floatValue);
            graph.addWithoutUnique((Node)halfFloatConstantNode);
            return halfFloatConstantNode;
        }
        if (halfFloatValue instanceof JavaReadNode && (javaReadNode = (JavaReadNode)halfFloatValue).getReadKind() == JavaKind.Float) {
            OCLConvertFloatToHalf convertFloatToHalf = new OCLConvertFloatToHalf((ValueNode)javaReadNode);
            graph.addWithoutUnique((Node)convertFloatToHalf);
            return convertFloatToHalf;
        }
        return halfFloatValue;
    }

    private static ValueNode replaceAdd(AddHalfFloatNode addHalfFloatNode, StructuredGraph graph) {
        ValueNode addNode;
        ValueNode addX = TornadoHalfFloatReplacement.getHalfOperand(addHalfFloatNode.getX(), graph);
        ValueNode addY = TornadoHalfFloatReplacement.getHalfOperand(addHalfFloatNode.getY(), graph);
        if (addX instanceof VectorLoadElementNode || addY instanceof VectorLoadElementNode) {
            addNode = new VectorAddHalfNode(addX, addY);
            graph.addWithoutUnique((Node)addNode);
        } else {
            addNode = new AddHalfNode(addX, addY);
            graph.addWithoutUnique((Node)addNode);
        }
        if (addHalfFloatNode.usages().filter(PiNode.class).isNotEmpty()) {
            PiNode piNode = (PiNode)addHalfFloatNode.usages().filter(PiNode.class).first();
            if (piNode.inputs().filter(ValueAnchorNode.class).isNotEmpty()) {
                ValueAnchorNode anchorNode = (ValueAnchorNode)piNode.inputs().filter(ValueAnchorNode.class).first();
                TornadoHalfFloatReplacement.deleteFixed((Node)anchorNode);
                piNode.replaceAtUsages((Node)addNode);
                piNode.safeDelete();
            } else {
                piNode.replaceAtUsages((Node)addNode);
                piNode.safeDelete();
            }
        } else {
            addHalfFloatNode.replaceAtUsages((Node)addNode);
        }
        addHalfFloatNode.safeDelete();
        return addNode;
    }

    private static void replaceAddHalfFloatNodes(StructuredGraph graph) {
        for (AddHalfFloatNode addHalfFloatNode : graph.getNodes().filter(AddHalfFloatNode.class)) {
            TornadoHalfFloatReplacement.replaceAdd(addHalfFloatNode, graph);
        }
    }

    public static ValueNode replaceSub(SubHalfFloatNode subHalfFloatNode, StructuredGraph graph) {
        ValueNode subNode;
        ValueNode subX = TornadoHalfFloatReplacement.getHalfOperand(subHalfFloatNode.getX(), graph);
        ValueNode subY = TornadoHalfFloatReplacement.getHalfOperand(subHalfFloatNode.getY(), graph);
        if (subX instanceof VectorLoadElementNode || subY instanceof VectorLoadElementNode) {
            subNode = new VectorSubHalfNode(subX, subY);
            graph.addWithoutUnique((Node)subNode);
        } else {
            subNode = new SubHalfNode(subX, subY);
            graph.addWithoutUnique((Node)subNode);
        }
        subHalfFloatNode.replaceAtUsages((Node)subNode);
        subHalfFloatNode.safeDelete();
        return subNode;
    }

    private static void replaceSubHalfFloatNodes(StructuredGraph graph) {
        for (SubHalfFloatNode subHalfFloatNode : graph.getNodes().filter(SubHalfFloatNode.class)) {
            TornadoHalfFloatReplacement.replaceSub(subHalfFloatNode, graph);
        }
    }

    private static ValueNode replaceMult(MultHalfFloatNode multHalfFloatNode, StructuredGraph graph) {
        ValueNode multNode;
        ValueNode multX = TornadoHalfFloatReplacement.getHalfOperand(multHalfFloatNode.getX(), graph);
        ValueNode multY = TornadoHalfFloatReplacement.getHalfOperand(multHalfFloatNode.getY(), graph);
        if (multX instanceof VectorLoadElementNode || multY instanceof VectorLoadElementNode) {
            multNode = new VectorMultHalfNode(multX, multY);
            graph.addWithoutUnique((Node)multNode);
        } else {
            multNode = new MultHalfNode(multX, multY);
            graph.addWithoutUnique((Node)multNode);
        }
        multHalfFloatNode.replaceAtUsages((Node)multNode);
        multHalfFloatNode.safeDelete();
        return multNode;
    }

    private static void replaceMultHalfFloatNodes(StructuredGraph graph) {
        for (MultHalfFloatNode multHalfFloatNode : graph.getNodes().filter(MultHalfFloatNode.class)) {
            TornadoHalfFloatReplacement.replaceMult(multHalfFloatNode, graph);
        }
    }

    private static ValueNode replaceDiv(DivHalfFloatNode divHalfFloatNode, StructuredGraph graph) {
        ValueNode divX = TornadoHalfFloatReplacement.getHalfOperand(divHalfFloatNode.getX(), graph);
        ValueNode divY = TornadoHalfFloatReplacement.getHalfOperand(divHalfFloatNode.getY(), graph);
        DivHalfNode divNode = new DivHalfNode(divX, divY);
        graph.addWithoutUnique((Node)divNode);
        divHalfFloatNode.replaceAtUsages((Node)divNode);
        divHalfFloatNode.safeDelete();
        return divNode;
    }

    private static void replaceDivHalfFloatNodes(StructuredGraph graph) {
        for (DivHalfFloatNode divHalfFloatNode : graph.getNodes().filter(DivHalfFloatNode.class)) {
            TornadoHalfFloatReplacement.replaceDiv(divHalfFloatNode, graph);
        }
    }

    private static ValuePhiNode replacePhi(ValuePhiNode phiNode, StructuredGraph graph) {
        if (phiNode.getStackKind().isObject()) {
            Object[] values = new ValueNode[phiNode.valueCount()];
            phiNode.values().toArray(values);
            ValuePhiNode halfPhiNode = new ValuePhiNode((Stamp)new HalfFloatStamp(), phiNode.merge(), (ValueNode[])values);
            graph.addWithoutUnique((Node)halfPhiNode);
            if (phiNode.usages().filter(ValueProxyNode.class).isNotEmpty()) {
                ValueProxyNode proxy = (ValueProxyNode)phiNode.usages().filter(ValueProxyNode.class).first();
                proxy.replaceAtUsages((Node)phiNode);
                proxy.safeDelete();
            }
            phiNode.replaceAtUsages((Node)halfPhiNode);
            phiNode.safeDelete();
            for (HalfFloatPlaceholder halfFloatPlaceholder : halfPhiNode.usages().filter(HalfFloatPlaceholder.class)) {
                for (FloatConvertNode floatConvertNode : halfFloatPlaceholder.usages().filter(FloatConvertNode.class)) {
                    OCLConvertHalfToFloat oclConvertHalfToFloat = new OCLConvertHalfToFloat((ValueNode)halfPhiNode);
                    graph.addWithoutUnique((Node)oclConvertHalfToFloat);
                    floatConvertNode.replaceAtUsages((Node)oclConvertHalfToFloat);
                    floatConvertNode.safeDelete();
                }
                halfFloatPlaceholder.replaceAtUsages((Node)halfPhiNode);
                halfFloatPlaceholder.safeDelete();
            }
            return halfPhiNode;
        }
        return phiNode;
    }

    private static boolean isWriteHalfFloat(JavaWriteNode javaWrite) {
        return javaWrite.value() instanceof HalfFloatPlaceholder;
    }

    private static void replaceFixed(Node n, Node other) {
        Node pred = n.predecessor();
        Node suc = n.successors().first();
        n.replaceFirstSuccessor(suc, null);
        n.replaceAtPredecessor(other);
        pred.replaceFirstSuccessor(n, other);
        other.replaceFirstSuccessor(null, suc);
        for (Node us : n.usages()) {
            n.removeUsage(us);
        }
        n.clearInputs();
        n.safeDelete();
    }

    private static ValueNode getHalfOperand(ValueNode operand, StructuredGraph graph) {
        Object halfOperand;
        if (operand instanceof VectorLoadElementNode) {
            VectorLoadElementNode loadElementNodeX = (VectorLoadElementNode)operand;
            halfOperand = new VectorLoadElementNode(OCLKind.HALF, loadElementNodeX.getVector(), loadElementNodeX.getLaneId());
            graph.addWithoutUnique((Node)halfOperand);
        } else if (operand instanceof ConstantNode) {
            ConstantNode c = (ConstantNode)operand;
            halfOperand = new ConstantNode(c.getValue(), StampFactory.forKind((JavaKind)JavaKind.Short));
            graph.addWithoutUnique((Node)halfOperand);
        } else {
            halfOperand = operand instanceof MultHalfFloatNode ? TornadoHalfFloatReplacement.replaceMult((MultHalfFloatNode)operand, graph) : (operand instanceof AddHalfFloatNode ? TornadoHalfFloatReplacement.replaceAdd((AddHalfFloatNode)operand, graph) : (operand instanceof SubHalfFloatNode ? TornadoHalfFloatReplacement.replaceSub((SubHalfFloatNode)operand, graph) : (operand instanceof DivHalfFloatNode ? TornadoHalfFloatReplacement.replaceDiv((DivHalfFloatNode)operand, graph) : (operand instanceof ValuePhiNode ? TornadoHalfFloatReplacement.replacePhi((ValuePhiNode)operand, graph) : operand))));
        }
        return halfOperand;
    }

    private static void deleteFixed(Node node) {
        if (!node.isDeleted()) {
            Node predecessor = node.predecessor();
            Node successor = node.successors().first();
            node.replaceFirstSuccessor(successor, null);
            node.replaceAtPredecessor(successor);
            predecessor.replaceFirstSuccessor(node, successor);
            for (Node us : node.usages()) {
                node.removeUsage(us);
            }
            node.clearInputs();
            node.safeDelete();
        }
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoHighTierContext context) {
        Node newHalfFloatInstance;
        for (ValueAnchorNode valueAnchorNode : graph.getNodes().filter(ValueAnchorNode.class)) {
            ArrayList<PiNode> deletePi = new ArrayList<PiNode>();
            for (Node valueAnchorNodeUsage : valueAnchorNode.usages()) {
                if (!(valueAnchorNodeUsage instanceof PiNode)) continue;
                PiNode piNode = (PiNode)valueAnchorNodeUsage;
                piNode.replaceAtUsages((Node)piNode.object());
                deletePi.add(piNode);
            }
            for (PiNode p : deletePi) {
                p.safeDelete();
            }
            TornadoHalfFloatReplacement.deleteFixed((Node)valueAnchorNode);
        }
        for (JavaReadNode javaRead : graph.getNodes().filter(JavaReadNode.class)) {
            NewInstanceNode newInstanceNode;
            if (!(javaRead.successors().first() instanceof NewInstanceNode) || javaRead.getReadKind() != JavaKind.Short || (newInstanceNode = (NewInstanceNode)javaRead.successors().first()).instanceClass().getAnnotation(HalfType.class) == null) continue;
            if (newInstanceNode.successors().first() instanceof NewHalfFloatInstance) {
                newHalfFloatInstance = (NewHalfFloatInstance)newInstanceNode.successors().first();
                TornadoHalfFloatReplacement.deleteFixed(newHalfFloatInstance);
            }
            AddressNode readingAddress = javaRead.getAddress();
            ReadHalfFloatNode readHalfFloatNode = new ReadHalfFloatNode(readingAddress);
            graph.addWithoutUnique((Node)readHalfFloatNode);
            TornadoHalfFloatReplacement.replaceFixed((Node)javaRead, (Node)readHalfFloatNode);
            newInstanceNode.replaceAtUsages((Node)readHalfFloatNode);
            TornadoHalfFloatReplacement.deleteFixed((Node)newInstanceNode);
        }
        for (NewInstanceNode newInstanceNode : graph.getNodes().filter(NewInstanceNode.class)) {
            JavaReadNode readValue;
            if (newInstanceNode.instanceClass().getAnnotation(HalfType.class) == null) continue;
            if (newInstanceNode.successors().first() instanceof NewHalfFloatInstance) {
                newHalfFloatInstance = (NewHalfFloatInstance)newInstanceNode.successors().first();
                ValueNode valueInput = TornadoHalfFloatReplacement.getHalfFloatValue(newHalfFloatInstance.getValue(), graph);
                newInstanceNode.replaceAtUsages((Node)valueInput);
                TornadoHalfFloatReplacement.deleteFixed((Node)newInstanceNode);
                TornadoHalfFloatReplacement.deleteFixed(newHalfFloatInstance);
                continue;
            }
            newHalfFloatInstance = newInstanceNode.successors().first();
            if (!(newHalfFloatInstance instanceof JavaReadNode) || (readValue = (JavaReadNode)newHalfFloatInstance).getReadKind() != JavaKind.Float) continue;
            OCLConvertFloatToHalf convertFloatToHalf = new OCLConvertFloatToHalf((ValueNode)readValue);
            graph.addWithoutUnique((Node)convertFloatToHalf);
            newInstanceNode.replaceAtUsages((Node)convertFloatToHalf);
            for (NewHalfFloatInstance newHalfFloatInstance2 : readValue.usages().filter(NewHalfFloatInstance.class)) {
                TornadoHalfFloatReplacement.deleteFixed((Node)newHalfFloatInstance2);
            }
            TornadoHalfFloatReplacement.deleteFixed((Node)newInstanceNode);
        }
        for (JavaWriteNode javaWrite : graph.getNodes().filter(JavaWriteNode.class)) {
            ValueNode writingValue;
            if (!TornadoHalfFloatReplacement.isWriteHalfFloat(javaWrite)) continue;
            HalfFloatPlaceholder placeholder = (HalfFloatPlaceholder)javaWrite.value();
            if (javaWrite.predecessor() instanceof NewHalfFloatInstance) {
                NewInstanceNode newInstanceNode;
                NewHalfFloatInstance newHalfFloatInstance3 = (NewHalfFloatInstance)javaWrite.predecessor();
                writingValue = newHalfFloatInstance3.getValue();
                if (newHalfFloatInstance3.predecessor() instanceof NewInstanceNode && (newInstanceNode = (NewInstanceNode)newHalfFloatInstance3.predecessor()).instanceClass().toString().contains("HalfFloat")) {
                    TornadoHalfFloatReplacement.deleteFixed((Node)newInstanceNode);
                    TornadoHalfFloatReplacement.deleteFixed((Node)newHalfFloatInstance3);
                }
            } else {
                writingValue = placeholder.getInput();
            }
            placeholder.replaceAtUsages((Node)writingValue);
            placeholder.safeDelete();
            AddressNode writingAddress = javaWrite.getAddress();
            WriteHalfFloatNode writeHalfFloatNode = new WriteHalfFloatNode(writingAddress, writingValue);
            graph.addWithoutUnique((Node)writeHalfFloatNode);
            TornadoHalfFloatReplacement.replaceFixed((Node)javaWrite, (Node)writeHalfFloatNode);
            TornadoHalfFloatReplacement.deleteFixed((Node)javaWrite);
        }
        TornadoHalfFloatReplacement.replaceAddHalfFloatNodes(graph);
        TornadoHalfFloatReplacement.replaceSubHalfFloatNodes(graph);
        TornadoHalfFloatReplacement.replaceMultHalfFloatNodes(graph);
        TornadoHalfFloatReplacement.replaceDivHalfFloatNodes(graph);
        for (LoadFieldNode loadFieldNode : graph.getNodes().filter(LoadFieldNode.class)) {
            if (!loadFieldNode.usages().filter(OCLConvertHalfToFloat.class).isNotEmpty()) continue;
            TornadoHalfFloatReplacement.replaceFieldAccess(loadFieldNode);
        }
        for (LoadIndexedVectorNode loadIndexedVectorNode : graph.getNodes().filter(LoadIndexedVectorNode.class)) {
            VectorHalfRead vectorHalfRead;
            if (!loadIndexedVectorNode.getOCLKind().isHalf()) continue;
            ValueNode writingAddress = loadIndexedVectorNode.index();
            if (writingAddress instanceof ConstantNode) {
                ConstantNode constantNode = (ConstantNode)writingAddress;
                int offsetValue = Integer.valueOf(constantNode.getValue().toValueString());
                vectorHalfRead = (VectorHalfRead)graph.addWithoutUnique((Node)new VectorHalfRead(offsetValue));
            } else {
                vectorHalfRead = (VectorHalfRead)graph.addWithoutUnique((Node)new VectorHalfRead());
            }
            graph.addAfterFixed((FixedWithNextNode)loadIndexedVectorNode, (FixedNode)vectorHalfRead);
        }
        for (VectorValueNode vectorValueNode : graph.getNodes().filter(VectorValueNode.class)) {
            if (!vectorValueNode.getOCLKind().isHalf()) continue;
            for (Node vectorElement : vectorValueNode.inputs()) {
                ConstantNode constantNode;
                if (vectorElement instanceof VectorLoadElementNode) {
                    VectorLoadElementNode vectorLoad = (VectorLoadElementNode)vectorElement;
                    VectorLoadElementNode vectorLoadShort = new VectorLoadElementNode(OCLKind.HALF, vectorLoad.getVector(), vectorLoad.getLaneId());
                    graph.addWithoutUnique((Node)vectorLoadShort);
                    vectorLoad.replaceAtUsages((Node)vectorLoadShort);
                    vectorLoad.safeDelete();
                    continue;
                }
                if (!(vectorElement instanceof ConstantNode) || !(constantNode = (ConstantNode)vectorElement).getValue().toValueString().contains("null")) continue;
                RawConstant zeroValue = new RawConstant(0L);
                ConstantNode zero = new ConstantNode((Constant)zeroValue, StampFactory.forKind((JavaKind)JavaKind.Short));
                graph.addWithoutUnique((Node)zero);
                constantNode.replaceAtUsages((Node)zero);
                constantNode.safeDelete();
            }
        }
    }
}

