/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Iterator;
import java.util.Optional;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.api.exceptions.TornadoCompilationException;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.FixedArrayCopyNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.FixedArrayNode;

public class TornadoFixedArrayCopyPhase
extends Phase {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        for (ValuePhiNode phiNode : graph.getNodes().filter(ValuePhiNode.class)) {
            if (!TornadoFixedArrayCopyPhase.isFixedArrayCopied(phiNode)) continue;
            FixedArrayNode fixedArrayNode = (FixedArrayNode)phiNode.values().filter(FixedArrayNode.class).first();
            ResolvedJavaType resolvedJavaType = fixedArrayNode.getElementType();
            OCLArchitecture.OCLMemoryBase oclMemoryBase = fixedArrayNode.getMemoryRegister();
            OffsetAddressNode offsetAddressNode = (OffsetAddressNode)phiNode.usages().filter(OffsetAddressNode.class).first();
            FixedArrayCopyNode fixedArrayCopyNode = new FixedArrayCopyNode(phiNode, resolvedJavaType, oclMemoryBase);
            graph.addWithoutUnique((Node)fixedArrayCopyNode);
            offsetAddressNode.replaceFirstInput((Node)phiNode, (Node)fixedArrayCopyNode);
            ValuePhiNode privateIndex = TornadoFixedArrayCopyPhase.getPrivateArrayIndex((Node)offsetAddressNode.getOffset());
            if (privateIndex == null) {
                throw new TornadoCompilationException("Index of FixedArrayNode is null.");
            }
            offsetAddressNode.setOffset((ValueNode)privateIndex);
        }
    }

    private static boolean isFixedArrayCopied(ValuePhiNode phiNode) {
        return phiNode.usages().filter(OffsetAddressNode.class).isNotEmpty() && phiNode.values().filter(FixedArrayNode.class).isNotEmpty();
    }

    private static ValuePhiNode getPrivateArrayIndex(Node node) {
        Iterator iterator = node.inputs().iterator();
        if (iterator.hasNext()) {
            Node input = (Node)iterator.next();
            if (input instanceof ValuePhiNode) {
                ValuePhiNode phiNode = (ValuePhiNode)input;
                return phiNode;
            }
            return TornadoFixedArrayCopyPhase.getPrivateArrayIndex(input);
        }
        return null;
    }
}

