/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.DecAtomicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.IncAtomicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.NodeAtomic;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.TornadoAtomicIntegerNode;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;

public class TornadoAtomicsScheduling
extends Phase {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    private Node getAtomicUsage(NodeAtomic nodeAtomic) {
        Node atomicUsage = nodeAtomic.usages().first();
        while (!(atomicUsage instanceof WriteNode)) {
            atomicUsage = atomicUsage.usages().first();
        }
        return atomicUsage;
    }

    private void fixStartWithNext(StructuredGraph graph, TornadoAtomicIntegerNode atomic) {
        StartNode startNode = graph.start();
        Node first = atomic.successors().first();
        while (first instanceof TornadoAtomicIntegerNode) {
            first = first.successors().first();
        }
        if (first != null && !(first instanceof StartNode)) {
            first.replaceAtPredecessor((Node)startNode);
            startNode.setNext((FixedNode)first);
        }
    }

    private void moveAtomicNodeToWriteBasicBloc(Node atomicUsage, TornadoAtomicIntegerNode atomic) {
        WriteNode writeNode = (WriteNode)atomicUsage;
        FixedWithNextNode pre = (FixedWithNextNode)writeNode.predecessor();
        if (atomic.predecessor() != null) {
            atomic.replaceAtPredecessor(null);
        }
        writeNode.replaceAtPredecessor((Node)atomic);
        pre.setNext((FixedNode)atomic);
        atomic.setNext((FixedNode)writeNode);
    }

    protected void run(StructuredGraph graph) {
        NodeIterable filter = graph.getNodes().filter(TornadoAtomicIntegerNode.class);
        if (!filter.isEmpty()) {
            for (TornadoAtomicIntegerNode atomic : filter) {
                NodeIterable usages = atomic.usages();
                int irCount = 1;
                for (Node usage : usages) {
                    if (!(usage instanceof IncAtomicNode) && !(usage instanceof DecAtomicNode)) continue;
                    Node atomicUsage = this.getAtomicUsage((NodeAtomic)usage);
                    this.fixStartWithNext(graph, atomic);
                    TornadoCoreRuntime.getDebugContext().dump(1, (Object)graph, "Atomics #" + irCount++);
                    this.moveAtomicNodeToWriteBasicBloc(atomicUsage, atomic);
                }
            }
        }
    }
}

