/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.NodeAtomic;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.TornadoAtomicIntegerNode;

public class TornadoAtomicsParametersPhase
extends Phase {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        NodeIterable filter = graph.getNodes().filter(NodeAtomic.class);
        if (!filter.isEmpty()) {
            for (NodeAtomic atomic : filter) {
                if (!(atomic.getAtomicNode() instanceof ParameterNode)) continue;
                ParameterNode atomicArgument = (ParameterNode)atomic.getAtomicNode();
                int indexNode = atomicArgument.index();
                TornadoAtomicIntegerNode newNode = new TornadoAtomicIntegerNode(OCLKind.INTEGER_ATOMIC_JAVA);
                graph.addOrUnique((Node)newNode);
                newNode.assignIndexFromParameter(indexNode);
                ConstantNode index = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forInt((int)0));
                newNode.setInitialValue((ValueNode)index);
                StartNode startNode = graph.start();
                FixedNode first = (FixedNode)startNode.successors().first();
                startNode.setNext((FixedNode)newNode);
                newNode.setNext(first);
                ParameterNode parameter = (ParameterNode)atomic.getAtomicNode();
                newNode.replaceAtMatchingUsages((Node)atomic, node -> !node.equals((Object)atomic));
                parameter.replaceAtMatchingUsages((Node)newNode, node -> node.equals((Object)atomic));
                assert (graph.verify());
            }
        }
    }
}

