/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.FPGAWorkGroupSizeNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.LocalWorkGroupDimensionsNode;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoLowTierContext;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLFPGAThreadScheduler
extends BasePhase<TornadoLowTierContext> {
    public static final int DEFAULT_FPGA_PARALLEL_1D = 64;
    public static final int DEFAULT_FPGA_PARALLEL_2D = 1;
    public static final int DEFAULT_FPGA_PARALLEL_3D = 1;
    public static final int DEFAULT_FPGA_SEQUENTIAL_1D = 1;
    public static final int DEFAULT_FPGA_SEQUENTIAL_2D = 1;
    public static final int DEFAULT_FPGA_SEQUENTIAL_3D = 1;
    private static int oneD = 64;
    private static int twoD = 1;
    private static int threeD = 1;

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoLowTierContext lowTierContext) {
        if (graph.hasLoops()) {
            NodeIterable filter = graph.getNodes().filter(EndNode.class);
            EndNode end = (EndNode)filter.first();
            TaskDataContext metaData = lowTierContext.getMeta();
            if (metaData != null) {
                if (metaData.isGridSchedulerEnabled()) {
                    if (metaData.isWorkerGridAvailable()) {
                        WorkerGrid workerGrid = metaData.getWorkerGrid(metaData.getId());
                        if (metaData.isGridSequential()) {
                            oneD = 1;
                            twoD = 1;
                            threeD = 1;
                        } else {
                            oneD = (int)workerGrid.getLocalWork()[0];
                            twoD = (int)workerGrid.getLocalWork()[1];
                            threeD = (int)workerGrid.getLocalWork()[2];
                        }
                    }
                } else if (!metaData.isParallel()) {
                    oneD = 1;
                    twoD = 1;
                    threeD = 1;
                }
            }
            ConstantNode xNode = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forInt((int)oneD));
            ConstantNode yNode = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forInt((int)twoD));
            ConstantNode zNode = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forInt((int)threeD));
            LocalWorkGroupDimensionsNode localWorkGroupNode = (LocalWorkGroupDimensionsNode)graph.addOrUnique((Node)new LocalWorkGroupDimensionsNode(xNode, yNode, zNode));
            FPGAWorkGroupSizeNode workGroupSizeNode = (FPGAWorkGroupSizeNode)graph.addOrUnique((Node)new FPGAWorkGroupSizeNode(localWorkGroupNode));
            graph.addBeforeFixed((FixedNode)end, (FixedWithNextNode)workGroupSizeNode);
        }
    }
}

