/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.List;
import java.util.Optional;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchorNode;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.DefaultLoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.IntelUnrollPragmaNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.XilinxPipeliningPragmaNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoLoopsData;

public class OCLFPGAPragmaPhase
extends Phase {
    private static final int UNROLL_FACTOR_NUMBER = 4;
    private static final int XILINX_PIPELINING_II_NUMBER = 1;
    private TornadoDeviceContext deviceContext;

    public OCLFPGAPragmaPhase(TornadoDeviceContext deviceContext) {
        this.deviceContext = deviceContext;
    }

    private static boolean shouldFullUnrollOrPipeline(OptionValues options, LoopEx loop) {
        if (!loop.isCounted() || !loop.counted().isConstantMaxTripCount()) {
            return false;
        }
        CountedLoopInfo counted = loop.counted();
        long maxTrips = counted.constantMaxTripCount().asLong();
        int maxNodes = counted.isExactTripCount() && counted.isConstantExactTripCount() ? (Integer)DefaultLoopPolicies.Options.ExactFullUnrollMaxNodes.getValue(options) : (Integer)DefaultLoopPolicies.Options.FullUnrollMaxNodes.getValue(options);
        maxNodes = Math.min(maxNodes, (Integer)GraalOptions.MaximumDesiredSize.getValue(options) - loop.loopBegin().graph().getNodeCount());
        int size = Math.max(1, loop.size() - 1 - loop.loopBegin().phis().count());
        if ((long)size * maxTrips <= (long)maxNodes) {
            int loops = 0;
            int ifs = 0;
            for (Node node : loop.inside().nodes()) {
                if (node instanceof ControlFlowAnchorNode) {
                    return false;
                }
                if (node instanceof LoopBeginNode) {
                    ++loops;
                    continue;
                }
                if (!(node instanceof IfNode)) continue;
                ++ifs;
            }
            if (loops - ifs != 0) {
                return true;
            }
            return true;
        }
        return true;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        if (graph.hasLoops() && this.deviceContext.isPlatformFPGA()) {
            boolean peeled;
            block0: do {
                peeled = false;
                TornadoLoopsData dataCounted = new TornadoLoopsData(graph);
                dataCounted.detectCountedLoops();
                for (LoopEx loop : dataCounted.countedLoops()) {
                    if (!OCLFPGAPragmaPhase.shouldFullUnrollOrPipeline(graph.getOptions(), loop)) continue;
                    List snapshot = graph.getNodes().filter(EndNode.class).snapshot();
                    int idx = 0;
                    for (EndNode end : snapshot) {
                        if (++idx != 2) continue;
                        if (this.deviceContext.isPlatformXilinxFPGA()) {
                            XilinxPipeliningPragmaNode pipeliningPragmaNode = (XilinxPipeliningPragmaNode)graph.addOrUnique((Node)new XilinxPipeliningPragmaNode(1));
                            graph.addBeforeFixed((FixedNode)end, (FixedWithNextNode)pipeliningPragmaNode);
                            continue;
                        }
                        IntelUnrollPragmaNode unrollPragmaNode = (IntelUnrollPragmaNode)graph.addOrUnique((Node)new IntelUnrollPragmaNode(4));
                        graph.addBeforeFixed((FixedNode)end, (FixedWithNextNode)unrollPragmaNode);
                    }
                    peeled = false;
                    continue block0;
                }
            } while (peeled);
        }
    }
}

