/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Optional;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.SqrtNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.api.exceptions.TornadoDeviceFP64NotSupported;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPBinaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPUnaryIntrinsicNode;

public class OCLFP64SupportPhase
extends Phase {
    private TornadoDeviceContext deviceContext;

    public OCLFP64SupportPhase(TornadoDeviceContext deviceContext) {
        this.deviceContext = deviceContext;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    private boolean isStampFP64Type(Stamp stamp) {
        return stamp.toString().contains("f64") || stamp.toString().toLowerCase().contains("double");
    }

    private void checkStampForFP64Support(Stamp stamp) {
        boolean isStampFP64Type = this.isStampFP64Type(stamp);
        if (isStampFP64Type && !this.deviceContext.isFP64Supported()) {
            throw new TornadoDeviceFP64NotSupported("The current OpenCL device (" + this.deviceContext.getDeviceName() + ") does not support FP64");
        }
    }

    protected void run(StructuredGraph graph) {
        graph.getNodes().filter(WriteNode.class).forEach(writeNode -> this.checkStampForFP64Support(writeNode.getAccessStamp(NodeView.DEFAULT)));
        graph.getNodes().filter(ReadNode.class).forEach(readNode -> this.checkStampForFP64Support(readNode.getAccessStamp(NodeView.DEFAULT)));
        graph.getNodes().filter(OCLFPUnaryIntrinsicNode.class).forEach(node -> this.checkStampForFP64Support(node.stamp(NodeView.DEFAULT)));
        graph.getNodes().filter(OCLFPBinaryIntrinsicNode.class).forEach(node -> this.checkStampForFP64Support(node.stamp(NodeView.DEFAULT)));
        graph.getNodes().filter(SqrtNode.class).forEach(node -> this.checkStampForFP64Support(node.stamp(NodeView.DEFAULT)));
    }
}

