/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Optional;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFMANode;

public class OCLFMAPhase
extends Phase {
    private boolean isValidType(ValueNode x) {
        return x.getStackKind() == JavaKind.Float || x.getStackKind() == JavaKind.Double;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        graph.getNodes().filter(AddNode.class).forEach(addNode -> {
            MulNode mulNode = null;
            if (addNode.getX() instanceof MulNode) {
                mulNode = (MulNode)addNode.getX();
            } else if (addNode.getY() instanceof MulNode) {
                mulNode = (MulNode)addNode.getY();
            }
            if (mulNode != null) {
                ValueNode x = mulNode.getX();
                ValueNode y = mulNode.getY();
                if (this.isValidType(x) && this.isValidType(y)) {
                    MulNode finalMulNode = mulNode;
                    ValueNode z = (ValueNode)addNode.inputs().filter(node -> !node.equals(finalMulNode)).first();
                    OCLFMANode oclFMA = new OCLFMANode(x, y, z);
                    graph.addOrUnique((Node)oclFMA);
                    mulNode.removeUsage((Node)addNode);
                    if (mulNode.hasNoUsages()) {
                        mulNode.safeDelete();
                    }
                    addNode.replaceAtUsages((Node)oclFMA);
                    addNode.safeDelete();
                }
            }
        });
    }
}

