/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatDivNode;
import org.graalvm.compiler.nodes.calc.SqrtNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.OCLFPUnaryIntrinsicNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.RSqrtNode;

public class InverseSquareRootPhase
extends Phase {
    private static final String ONE = "1.0";
    private static final String SQRT = "SQRT";

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        graph.getNodes().filter(FloatDivNode.class).forEach(floatDivisionNode -> {
            ConstantNode constant;
            ValueNode patt0$temp = floatDivisionNode.getX();
            if (patt0$temp instanceof ConstantNode && (constant = (ConstantNode)patt0$temp).getValue().toValueString().equals(ONE)) {
                ValueNode patt1$temp = floatDivisionNode.getY();
                if (patt1$temp instanceof SqrtNode) {
                    SqrtNode intrinsicNode = (SqrtNode)patt1$temp;
                    n = intrinsicNode.getValue();
                    RSqrtNode rsqrtNode = new RSqrtNode(n);
                    graph.addOrUnique((Node)rsqrtNode);
                    intrinsicNode.removeUsage((Node)floatDivisionNode);
                    if (intrinsicNode.hasNoUsages()) {
                        intrinsicNode.safeDelete();
                    }
                    floatDivisionNode.replaceAtUsages((Node)rsqrtNode);
                    floatDivisionNode.safeDelete();
                } else {
                    OCLFPUnaryIntrinsicNode OCLFPUnaryIntrinsicNode2;
                    ValueNode patt2$temp = floatDivisionNode.getY();
                    if (patt2$temp instanceof OCLFPUnaryIntrinsicNode && (OCLFPUnaryIntrinsicNode2 = (OCLFPUnaryIntrinsicNode)patt2$temp).getOperation().equals(SQRT)) {
                        n = OCLFPUnaryIntrinsicNode2.getValue();
                        RSqrtNode rsqrtNode = new RSqrtNode(n);
                        graph.addOrUnique((Node)rsqrtNode);
                        OCLFPUnaryIntrinsicNode2.removeUsage((Node)floatDivisionNode);
                        if (OCLFPUnaryIntrinsicNode2.hasNoUsages()) {
                            OCLFPUnaryIntrinsicNode2.safeDelete();
                        }
                        floatDivisionNode.replaceAtUsages((Node)rsqrtNode);
                        floatDivisionNode.safeDelete();
                    }
                }
            }
        });
    }
}

