/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.phases;

import java.util.Optional;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatDivNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;

public class InfinityReplacementPhase
extends Phase {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph) {
        graph.getNodes().filter(ConstantNode.class).forEach(constantNode -> {
            String resultValue = constantNode.getValue().toValueString();
            if (resultValue.equals("Infinity") || resultValue.equals("-Infinity")) {
                float constantValue = resultValue.equals("Infinity") ? 1.0f : -1.0f;
                this.replaceWithDivisionNode(constantValue, graph, (ConstantNode)constantNode);
            }
        });
    }

    private void replaceWithDivisionNode(float constantValue, StructuredGraph graph, ConstantNode constantNode) {
        ConstantNode constant = ConstantNode.forConstant((JavaConstant)JavaConstant.forFloat((float)constantValue), null, (StructuredGraph)graph);
        ConstantNode constantZero = ConstantNode.forConstant((JavaConstant)JavaConstant.forFloat((float)0.0f), null, (StructuredGraph)graph);
        FloatDivNode divisionNode = new FloatDivNode((ValueNode)constant, (ValueNode)constantZero);
        graph.addOrUnique((Node)divisionNode);
        constantNode.replaceAtUsages((Node)divisionNode);
        if (constantNode.hasNoUsages()) {
            constantNode.safeDelete();
        }
    }
}

