/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector;

import java.util.List;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLNodeLIRBuilder;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLVectorAssign;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorLoadElementNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorOp;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorStoreElementProxyNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorUtil;

@NodeInfo(nameTemplate="{p#kind/s}")
public class VectorValueNode
extends FloatingNode
implements LIRLowerable {
    public static final NodeClass<VectorValueNode> TYPE = NodeClass.create(VectorValueNode.class);
    private final OCLKind kind;
    @Node.Input
    NodeInputList<ValueNode> values;
    @Node.OptionalInput(value=InputType.Association)
    private ValueNode origin;

    public VectorValueNode(OCLKind kind) {
        super(TYPE, (Stamp)OCLStampFactory.getStampFor(kind));
        this.kind = kind;
        this.values = new NodeInputList((Node)this, kind.getVectorLength());
    }

    public void initialiseToDefaultValues(StructuredGraph graph) {
        ConstantNode defaultValue = ConstantNode.forPrimitive((JavaConstant)this.kind.getElementKind().getDefaultValue(), (StructuredGraph)graph);
        for (int i = 0; i < this.kind.getVectorLength(); ++i) {
            this.setElement(i, (ValueNode)defaultValue);
        }
    }

    public OCLKind getOCLKind() {
        return this.kind;
    }

    public ValueNode length() {
        return ConstantNode.forInt((int)this.kind.getVectorLength());
    }

    public ValueNode getElement(int index) {
        return (ValueNode)this.values.get(index);
    }

    private void replaceInputAtIndex(Node replacement, int index) {
        int i = 0;
        for (Node input : this.inputs()) {
            if (i++ != index) continue;
            this.replaceFirstInput(input, replacement);
            break;
        }
    }

    private boolean isInputValueAtIndexSet(int index) {
        return this.values.get(index) != null;
    }

    public void setElement(int index, ValueNode value) {
        if (this.isInputValueAtIndexSet(index)) {
            this.replaceInputAtIndex((Node)value, index);
        } else {
            this.values.set(index, (Object)value);
        }
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        if (this.origin instanceof InvokeNode) {
            gen.setResult((ValueNode)this, gen.operand((Node)this.origin));
        } else if (this.origin instanceof ValuePhiNode) {
            ValuePhiNode phi = (ValuePhiNode)this.origin;
            Value phiOperand = ((OCLNodeLIRBuilder)gen).operandForPhi(phi);
            Variable result = gen.hasOperand((Node)this) ? (Variable)gen.operand((Node)this) : tool.newVariable((ValueKind)LIRKind.value((PlatformKind)this.getOCLKind()));
            tool.append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)result, phiOperand));
            gen.setResult((ValueNode)this, (Value)result);
        } else if (this.origin instanceof ParameterNode) {
            gen.setResult((ValueNode)this, gen.operand((Node)this.origin));
        } else if (this.origin == null) {
            Variable result = tool.newVariable((ValueKind)LIRKind.value((PlatformKind)this.getOCLKind()));
            int numValues = this.values.count();
            ValueNode firstValue = (ValueNode)this.values.first();
            if (firstValue instanceof VectorValueNode || firstValue instanceof VectorOp) {
                tool.append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)result, gen.operand(this.values.first())));
                gen.setResult((ValueNode)this, (Value)result);
            } else if (numValues > 0 && gen.hasOperand((Node)firstValue)) {
                this.generateVectorAssign(gen, tool, (AllocatableValue)result);
            } else {
                gen.setResult((ValueNode)this, (Value)result);
            }
        }
    }

    private Value getParam(NodeLIRBuilderTool gen, LIRGeneratorTool tool, int index) {
        ValueNode valueNode = (ValueNode)this.values.get(index);
        if (valueNode instanceof VectorLoadElementNode && this.kind.isHalf()) {
            return this.emitHalfFloatAssign(valueNode, tool, gen);
        }
        return valueNode == null ? new ConstantValue((ValueKind)LIRKind.value((PlatformKind)this.kind), (Constant)this.kind.getDefaultValue()) : tool.emitMove(gen.operand((Node)valueNode));
    }

    private Variable emitHalfFloatAssign(ValueNode vectorValue, LIRGeneratorTool tool, NodeLIRBuilderTool gen) {
        Variable result = tool.newVariable((ValueKind)LIRKind.value((PlatformKind)OCLKind.HALF));
        Value vectorField = gen.operand((Node)vectorValue);
        tool.emitMove((AllocatableValue)result, vectorField);
        return result;
    }

    private void generateVectorAssign(NodeLIRBuilderTool gen, LIRGeneratorTool tool, AllocatableValue result) {
        OCLVectorAssign.Assign2Expr assignExpr = null;
        Value s0 = this.getParam(gen, tool, 0);
        if (this.kind.getVectorLength() >= 2 && ((OCLKind)s0.getPlatformKind()).isVector()) {
            gen.setResult((ValueNode)this, s0);
            return;
        }
        switch (this.kind.getVectorLength()) {
            case 2: {
                OCLAssembler.OCLOp2 op2 = VectorUtil.resolveAssignOp2(this.getOCLKind());
                Value s1 = this.getParam(gen, tool, 1);
                assignExpr = new OCLVectorAssign.Assign2Expr(op2, this.getOCLKind(), s0, s1);
                break;
            }
            case 3: {
                OCLAssembler.OCLOp3 op3 = VectorUtil.resolveAssignOp3(this.getOCLKind());
                Value s1 = this.getParam(gen, tool, 1);
                Value s2 = this.getParam(gen, tool, 2);
                assignExpr = new OCLVectorAssign.Assign3Expr(op3, this.getOCLKind(), s0, s1, s2);
                break;
            }
            case 4: {
                OCLAssembler.OCLOp4 op4 = VectorUtil.resolveAssignOp4(this.getOCLKind());
                Value s1 = this.getParam(gen, tool, 1);
                Value s2 = this.getParam(gen, tool, 2);
                Value s3 = this.getParam(gen, tool, 3);
                assignExpr = new OCLVectorAssign.Assign4Expr(op4, this.getOCLKind(), s0, s1, s2, s3);
                break;
            }
            case 8: {
                OCLAssembler.OCLOp8 op8 = VectorUtil.resolveAssignOp8(this.getOCLKind());
                Value s1 = this.getParam(gen, tool, 1);
                Value s2 = this.getParam(gen, tool, 2);
                Value s3 = this.getParam(gen, tool, 3);
                Value s4 = this.getParam(gen, tool, 4);
                Value s5 = this.getParam(gen, tool, 5);
                Value s6 = this.getParam(gen, tool, 6);
                Value s7 = this.getParam(gen, tool, 7);
                assignExpr = new OCLVectorAssign.Assign8Expr(op8, this.getOCLKind(), s0, s1, s2, s3, s4, s5, s6, s7);
                break;
            }
            case 16: {
                OCLAssembler.OCLOp16 op16 = VectorUtil.resolveAssignOp16(this.getOCLKind());
                Value s1 = this.getParam(gen, tool, 1);
                Value s2 = this.getParam(gen, tool, 2);
                Value s3 = this.getParam(gen, tool, 3);
                Value s4 = this.getParam(gen, tool, 4);
                Value s5 = this.getParam(gen, tool, 5);
                Value s6 = this.getParam(gen, tool, 6);
                Value s7 = this.getParam(gen, tool, 7);
                Value s8 = this.getParam(gen, tool, 8);
                Value s9 = this.getParam(gen, tool, 9);
                Value s10 = this.getParam(gen, tool, 10);
                Value s11 = this.getParam(gen, tool, 11);
                Value s12 = this.getParam(gen, tool, 12);
                Value s13 = this.getParam(gen, tool, 13);
                Value s14 = this.getParam(gen, tool, 14);
                Value s15 = this.getParam(gen, tool, 15);
                assignExpr = new OCLVectorAssign.Assign16Expr(op16, this.getOCLKind(), s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15);
                break;
            }
            default: {
                TornadoInternalError.unimplemented((String)("new vector length = " + this.kind.getVectorLength()));
            }
        }
        tool.append((LIRInstruction)new OCLLIRStmt.AssignStmt(result, assignExpr));
        gen.setResult((ValueNode)this, (Value)result);
    }

    public List<VectorStoreElementProxyNode> getLanesInputs() {
        return this.usages().filter(VectorStoreElementProxyNode.class).snapshot();
    }

    public boolean allLanesSet() {
        return this.values.count() == 1 && this.values.first() instanceof VectorValueNode || this.values.filter(VectorLoadElementNode.class).count() == this.kind.getVectorLength();
    }

    public void set(ValueNode value) {
        this.values.clear();
        this.values.add((Object)value);
    }

    public void deleteUnusedLoads() {
        this.usages().filter(VectorLoadElementNode.class).forEach(node -> {
            if (node.hasNoUsages()) {
                this.values.remove(node);
                node.safeDelete();
            }
        });
    }

    public boolean isLaneSet(int index) {
        if (this.values.count() < index) {
            return false;
        }
        return false;
    }

    public void clearOrigin() {
        this.replaceFirstInput((Node)this.origin, null);
    }

    public ValueNode getOrigin() {
        return this.origin;
    }

    public void setOrigin(ValueNode value) {
        this.updateUsages((Node)this.origin, (Node)value);
        this.origin = value;
    }

    public VectorValueNode duplicate() {
        return (VectorValueNode)this.graph().addWithoutUnique((Node)new VectorValueNode(this.kind));
    }
}

