/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector;

import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;

public final class VectorUtil {
    private static final OCLAssembler.OCLBinaryIntrinsic[] loadTable = new OCLAssembler.OCLBinaryIntrinsic[]{OCLAssembler.OCLBinaryIntrinsic.VLOAD2, OCLAssembler.OCLBinaryIntrinsic.VLOAD3, OCLAssembler.OCLBinaryIntrinsic.VLOAD4, OCLAssembler.OCLBinaryIntrinsic.VLOAD8, OCLAssembler.OCLBinaryIntrinsic.VLOAD16};
    private static final OCLAssembler.OCLTernaryIntrinsic[] storeTable = new OCLAssembler.OCLTernaryIntrinsic[]{OCLAssembler.OCLTernaryIntrinsic.VSTORE2, OCLAssembler.OCLTernaryIntrinsic.VSTORE3, OCLAssembler.OCLTernaryIntrinsic.VSTORE4, OCLAssembler.OCLTernaryIntrinsic.VSTORE8, OCLAssembler.OCLTernaryIntrinsic.VSTORE16};
    private static final OCLAssembler.OCLUnaryOp[] pointerTable = new OCLAssembler.OCLUnaryOp[]{OCLAssembler.OCLUnaryOp.CAST_TO_SHORT_PTR, OCLAssembler.OCLUnaryOp.CAST_TO_INT_PTR, OCLAssembler.OCLUnaryOp.CAST_TO_FLOAT_PTR, OCLAssembler.OCLUnaryOp.CAST_TO_BYTE_PTR};
    private static final OCLAssembler.OCLOp2[] assignOp2Table = new OCLAssembler.OCLOp2[]{OCLAssembler.OCLOp2.VMOV_SHORT2, OCLAssembler.OCLOp2.VMOV_INT2, OCLAssembler.OCLOp2.VMOV_FLOAT2, OCLAssembler.OCLOp2.VMOV_BYTE2, OCLAssembler.OCLOp2.VMOV_DOUBLE2, OCLAssembler.OCLOp2.VMOV_HALF2};
    private static final OCLAssembler.OCLOp3[] assignOp3Table = new OCLAssembler.OCLOp3[]{OCLAssembler.OCLOp3.VMOV_SHORT3, OCLAssembler.OCLOp3.VMOV_INT3, OCLAssembler.OCLOp3.VMOV_FLOAT3, OCLAssembler.OCLOp3.VMOV_BYTE3, OCLAssembler.OCLOp3.VMOV_DOUBLE3, OCLAssembler.OCLOp3.VMOV_HALF3};
    private static final OCLAssembler.OCLOp4[] assignOp4Table = new OCLAssembler.OCLOp4[]{OCLAssembler.OCLOp4.VMOV_SHORT4, OCLAssembler.OCLOp4.VMOV_INT4, OCLAssembler.OCLOp4.VMOV_FLOAT4, OCLAssembler.OCLOp4.VMOV_BYTE4, OCLAssembler.OCLOp4.VMOV_DOUBLE4, OCLAssembler.OCLOp4.VMOV_HALF4};
    private static final OCLAssembler.OCLOp8[] assignOp8Table = new OCLAssembler.OCLOp8[]{OCLAssembler.OCLOp8.VMOV_SHORT8, OCLAssembler.OCLOp8.VMOV_INT8, OCLAssembler.OCLOp8.VMOV_FLOAT8, OCLAssembler.OCLOp8.VMOV_BYTE8, OCLAssembler.OCLOp8.VMOV_DOUBLE8, OCLAssembler.OCLOp8.VMOV_HALF8};
    private static final OCLAssembler.OCLOp16[] assignOp16Table = new OCLAssembler.OCLOp16[]{OCLAssembler.OCLOp16.VMOV_SHORT16, OCLAssembler.OCLOp16.VMOV_INT16, OCLAssembler.OCLOp16.VMOV_FLOAT16, OCLAssembler.OCLOp16.VMOV_BYTE16, OCLAssembler.OCLOp16.VMOV_DOUBLE16, OCLAssembler.OCLOp16.VMOV_HALF16};

    private static <T> T lookupValueByLength(T[] array, OCLKind vectorKind) {
        int index = vectorKind.lookupLengthIndex();
        if (index != -1) {
            return array[index];
        }
        throw TornadoInternalError.shouldNotReachHere((String)("Unsupported vector type: " + vectorKind.toString()));
    }

    private static <T> T lookupValueByType(T[] array, OCLKind vectorKind) {
        int index = vectorKind.lookupTypeIndex();
        if (index != -1) {
            return array[index];
        }
        throw TornadoInternalError.shouldNotReachHere((String)("Unsupported vector type: " + vectorKind.toString()));
    }

    public static OCLAssembler.OCLOp2 resolveAssignOp2(OCLKind vectorKind) {
        return VectorUtil.lookupValueByType(assignOp2Table, vectorKind);
    }

    public static OCLAssembler.OCLOp3 resolveAssignOp3(OCLKind vectorKind) {
        return VectorUtil.lookupValueByType(assignOp3Table, vectorKind);
    }

    public static OCLAssembler.OCLOp4 resolveAssignOp4(OCLKind vectorKind) {
        return VectorUtil.lookupValueByType(assignOp4Table, vectorKind);
    }

    public static OCLAssembler.OCLOp8 resolveAssignOp8(OCLKind vectorKind) {
        return VectorUtil.lookupValueByType(assignOp8Table, vectorKind);
    }

    public static OCLAssembler.OCLOp16 resolveAssignOp16(OCLKind vectorKind) {
        return VectorUtil.lookupValueByType(assignOp16Table, vectorKind);
    }

    public static OCLAssembler.OCLTernaryIntrinsic resolveStoreIntrinsic(OCLKind vectorKind) {
        return VectorUtil.lookupValueByLength(storeTable, vectorKind);
    }

    public static OCLAssembler.OCLBinaryIntrinsic resolveLoadIntrinsic(OCLKind vectorKind) {
        return VectorUtil.lookupValueByLength(loadTable, vectorKind);
    }
}

