/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorValueNode;

@NodeInfo(nameTemplate="Store .s{p#lane}")
public final class VectorStoreElementProxyNode
extends FixedWithNextNode
implements Canonicalizable {
    public static final NodeClass<VectorStoreElementProxyNode> TYPE = NodeClass.create(VectorStoreElementProxyNode.class);
    @Node.Input
    ValueNode value;
    @Node.OptionalInput(value=InputType.Association)
    ValueNode origin;
    @Node.OptionalInput(value=InputType.Association)
    ValueNode laneOrigin;

    public ValueNode value() {
        return this.value;
    }

    private VectorStoreElementProxyNode(NodeClass<? extends VectorStoreElementProxyNode> c, OCLKind kind, ValueNode origin, ValueNode lane) {
        super(c, (Stamp)OCLStampFactory.getStampFor(kind));
        this.origin = origin;
        this.laneOrigin = lane;
    }

    public boolean tryResolve() {
        if (this.canResolve()) {
            VectorValueNode vector = (VectorValueNode)this.origin;
            vector.setElement(((ConstantNode)this.laneOrigin).asJavaConstant().asInt(), this.value);
            this.clearInputs();
            return true;
        }
        return false;
    }

    public VectorStoreElementProxyNode(OCLKind kind, ValueNode origin, ValueNode lane, ValueNode value) {
        this(TYPE, kind, origin, lane);
        this.value = value;
    }

    public boolean inferStamp() {
        return true;
    }

    public boolean canResolve() {
        return this.origin != null && this.laneOrigin != null && this.origin instanceof VectorValueNode && this.laneOrigin instanceof ConstantNode && ((VectorValueNode)this.origin).getOCLKind().getVectorLength() > this.laneOrigin.asJavaConstant().asInt();
    }

    public ValueNode getOrigin() {
        return this.origin;
    }

    public void setOrigin(ValueNode value) {
        this.origin = value;
    }

    public int getLane() {
        return ((ConstantNode)this.laneOrigin).asJavaConstant().asInt();
    }

    public Node canonical(CanonicalizerTool ct) {
        if (this.tryResolve()) {
            return null;
        }
        return this;
    }
}

