/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorLoadElementNode;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorValueNode;

@Deprecated
@NodeInfo(nameTemplate="Load .s{p#lane}")
public final class VectorLoadElementProxyNode
extends FixedWithNextNode {
    public static final NodeClass<VectorLoadElementProxyNode> TYPE = NodeClass.create(VectorLoadElementProxyNode.class);
    @Node.OptionalInput(value=InputType.Association)
    ValueNode origin;
    @Node.OptionalInput(value=InputType.Association)
    ValueNode laneOrigin;
    private final OCLKind kind;

    protected VectorLoadElementProxyNode(NodeClass<? extends VectorLoadElementProxyNode> c, OCLKind kind, ValueNode origin, ValueNode lane) {
        super(c, (Stamp)OCLStampFactory.getStampFor(kind));
        this.kind = kind;
        this.origin = origin;
        this.laneOrigin = lane;
    }

    public VectorLoadElementNode tryResolve() {
        VectorLoadElementNode loadNode = null;
        if (this.canResolve()) {
            VectorValueNode vector = null;
            if (this.origin instanceof VectorValueNode) {
                vector = (VectorValueNode)this.origin;
            } else {
                TornadoInternalError.shouldNotReachHere();
            }
            loadNode = new VectorLoadElementNode(this.kind, (ValueNode)vector, this.laneOrigin);
            this.clearInputs();
        }
        return loadNode;
    }

    public boolean inferStamp() {
        return true;
    }

    public OCLKind getOCLKind() {
        return this.kind;
    }

    public boolean canResolve() {
        return this.isVectorValueNode() && this.laneOrigin != null && this.laneOrigin instanceof ConstantNode;
    }

    private boolean isVectorValueNode() {
        return this.origin != null && this.origin instanceof VectorValueNode;
    }
}

