/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;

@NodeInfo(nameTemplate=".{p#selection}")
public class VectorElementSelectNode
extends FloatingNode
implements LIRLowerable {
    public static final NodeClass<VectorElementSelectNode> TYPE = NodeClass.create(VectorElementSelectNode.class);
    @Node.Input(value=InputType.Extension)
    ValueNode vector;
    @Node.Input
    ValueNode selection;

    public VectorElementSelectNode(OCLKind kind, ValueNode vector, ValueNode selection) {
        super(TYPE, StampFactory.forKind((JavaKind)kind.asJavaKind()));
        this.vector = vector;
        this.selection = selection;
    }

    public boolean inferStamp() {
        return true;
    }

    public ValueNode getSelection() {
        return this.selection;
    }

    public ValueNode getVector() {
        return this.vector;
    }

    public void generate(NodeLIRBuilderTool gen) {
        TornadoInternalError.guarantee((this.vector != null ? 1 : 0) != 0, (String)"vector operand is null", (Object[])new Object[0]);
        Value targetVector = gen.operand((Node)this.getVector());
        Value selectValue = gen.operand((Node)this.getSelection());
        TornadoInternalError.guarantee((targetVector != null ? 1 : 0) != 0, (String)"vector value is null 2", (Object[])new Object[0]);
        TornadoInternalError.guarantee((selectValue != null ? 1 : 0) != 0, (String)"select value is null", (Object[])new Object[0]);
        OCLBinary.Selector expr = new OCLBinary.Selector(OCLAssembler.OCLBinaryOp.VECTOR_SELECT, gen.getLIRGeneratorTool().getLIRKind(this.stamp), targetVector, selectValue);
        gen.setResult((ValueNode)this, (Value)expr);
    }
}

