/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLVectorElementSelect;

@NodeInfo(nameTemplate="Op .s{p#lane}")
public abstract class VectorElementOpNode
extends FloatingNode
implements LIRLowerable,
Comparable<VectorElementOpNode> {
    public static final NodeClass<VectorElementOpNode> TYPE = NodeClass.create(VectorElementOpNode.class);
    protected final OCLKind oclKind;
    @Node.Input(value=InputType.Extension)
    ValueNode vector;
    @Node.Input
    ValueNode lane;

    protected VectorElementOpNode(NodeClass<? extends VectorElementOpNode> c, OCLKind kind, ValueNode vector, ValueNode lane) {
        super(c, StampFactory.forKind((JavaKind)kind.asJavaKind()));
        this.oclKind = kind;
        this.vector = vector;
        this.lane = lane;
        Stamp vectorStamp = vector.stamp(NodeView.DEFAULT);
        if (vectorStamp instanceof ObjectStamp) {
            ObjectStamp objectStamp = (ObjectStamp)vector.stamp(NodeView.DEFAULT);
            if (objectStamp.type() != null) {
                OCLKind vectorKind = OCLKind.fromResolvedJavaType(objectStamp.type());
                TornadoInternalError.guarantee((boolean)vectorKind.isVector(), (String)"Cannot apply vector operation to non-vector type: %s", (Object[])new Object[]{vectorKind});
                TornadoInternalError.guarantee((vectorKind.getVectorLength() >= this.laneId() ? 1 : 0) != 0, (String)"Invalid lane %d on type %s", (Object[])new Object[]{this.laneId(), this.oclKind});
            }
        } else {
            TornadoInternalError.shouldNotReachHere((String)"invalid type on vector operation: %s (stamp=%s (class=%s))", (Object[])new Object[]{vector, vector.stamp(NodeView.DEFAULT), vector.stamp(NodeView.DEFAULT).getClass().getName()});
        }
    }

    @Override
    public int compareTo(VectorElementOpNode o) {
        return Integer.compare(this.laneId(), o.laneId());
    }

    public boolean inferStamp() {
        return this.updateStamp(StampFactory.forKind((JavaKind)this.oclKind.asJavaKind()));
    }

    public final int laneId() {
        TornadoInternalError.guarantee((boolean)(this.lane instanceof ConstantNode), (String)"Invalid lane: %s", (Object[])new Object[]{this.lane});
        return this.lane instanceof ConstantNode ? this.lane.asJavaConstant().asInt() : -1;
    }

    public final ValueNode getLaneId() {
        return this.lane;
    }

    public ValueNode getVector() {
        return this.vector;
    }

    public void generate(NodeLIRBuilderTool gen) {
        TornadoInternalError.guarantee((this.vector != null ? 1 : 0) != 0, (String)"vector is null", (Object[])new Object[0]);
        Value targetVector = gen.operand((Node)this.getVector());
        TornadoInternalError.guarantee((targetVector != null ? 1 : 0) != 0, (String)"vector is null", (Object[])new Object[0]);
        OCLVectorElementSelect element = new OCLVectorElementSelect(gen.getLIRGeneratorTool().getLIRKind(this.stamp), targetVector, (Value)new ConstantValue((ValueKind)LIRKind.value((PlatformKind)OCLKind.INT), (Constant)JavaConstant.forInt((int)this.laneId())));
        gen.setResult((ValueNode)this, (Value)element);
    }
}

