/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.common.logging.Logger;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorOp;

@NodeInfo(shortName="Vector(/)")
public class VectorDivNode
extends FloatingNode
implements LIRLowerable,
VectorOp {
    public static final NodeClass<VectorDivNode> TYPE = NodeClass.create(VectorDivNode.class);
    @Node.Input
    ValueNode x;
    @Node.Input
    ValueNode y;

    public VectorDivNode(OCLKind kind, ValueNode x, ValueNode y) {
        this(TYPE, kind, x, y);
    }

    protected VectorDivNode(NodeClass<? extends VectorDivNode> c, OCLKind kind, ValueNode x, ValueNode y) {
        super(c, (Stamp)OCLStampFactory.getStampFor(kind));
        this.x = x;
        this.y = y;
    }

    public ValueNode getX() {
        return this.x;
    }

    public ValueNode getY() {
        return this.y;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRKind lirKind = gen.getLIRGeneratorTool().getLIRKind(this.stamp);
        Variable result = gen.getLIRGeneratorTool().newVariable((ValueKind)lirKind);
        Value input1 = gen.operand((Node)this.x);
        Value input2 = gen.operand((Node)this.y);
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitVectorDiv: %s + %s", (Object[])new Object[]{input1, input2});
        gen.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)result, new OCLBinary.Expr(OCLAssembler.OCLBinaryOp.DIV, gen.getLIRGeneratorTool().getLIRKind(this.stamp), input1, input2)));
        gen.setResult((ValueNode)this, (Value)result);
    }
}

