/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.common.logging.Logger;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStamp;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.vector.VectorOp;

@NodeInfo(shortName="+")
public class VectorAddNode
extends BinaryNode
implements LIRLowerable,
VectorOp {
    public static final NodeClass<VectorAddNode> TYPE = NodeClass.create(VectorAddNode.class);

    public VectorAddNode(OCLKind kind, ValueNode x, ValueNode y) {
        super(TYPE, (Stamp)OCLStampFactory.getStampFor(kind), x, y);
    }

    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        Stamp currentStamp = this.stamp(NodeView.DEFAULT);
        if (currentStamp instanceof OCLStamp) {
            return currentStamp;
        }
        return stampX instanceof OCLStamp ? stampX.join(stampY) : stampY.join(stampX);
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRKind lirKind = gen.getLIRGeneratorTool().getLIRKind(this.stamp);
        Variable result = gen.getLIRGeneratorTool().newVariable((ValueKind)lirKind);
        Value input1 = gen.operand((Node)this.x);
        Value input2 = gen.operand((Node)this.y);
        Logger.traceBuildLIR((Logger.BACKEND)Logger.BACKEND.OpenCL, (String)"emitVectorAdd: %s + %s", (Object[])new Object[]{input1, input2});
        gen.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)result, new OCLBinary.Expr(OCLAssembler.OCLBinaryOp.ADD, gen.getLIRGeneratorTool().getLIRKind(this.stamp), input1, input2)));
        gen.setResult((ValueNode)this, (Value)result);
    }

    public Node canonical(CanonicalizerTool ct, ValueNode t, ValueNode t1) {
        return this;
    }

    public ValueNode canonical(CanonicalizerTool ct) {
        return this;
    }
}

