/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.HalfFloatStamp;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;

@NodeInfo
public class WriteHalfFloatNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<WriteHalfFloatNode> TYPE = NodeClass.create(WriteHalfFloatNode.class);
    @Node.Input
    private AddressNode addressNode;
    @Node.Input
    private ValueNode valueNode;
    @Node.Input
    private ValueNode indexNode;

    public WriteHalfFloatNode(AddressNode addressNode, ValueNode valueNode) {
        super(TYPE, (Stamp)new HalfFloatStamp());
        this.addressNode = addressNode;
        this.valueNode = valueNode;
    }

    public WriteHalfFloatNode(AddressNode addressNode, ValueNode valueNode, ValueNode indexNode) {
        super(TYPE, (Stamp)new HalfFloatStamp());
        this.addressNode = addressNode;
        this.valueNode = valueNode;
        this.indexNode = indexNode;
    }

    public void generate(NodeLIRBuilderTool generator) {
        LIRGeneratorTool tool = generator.getLIRGeneratorTool();
        Value addressValue = generator.operand((Node)this.addressNode);
        OCLArchitecture.OCLMemoryBase base = ((OCLUnary.MemoryAccess)addressValue).getBase();
        OCLUnary.OCLAddressCast cast = new OCLUnary.OCLAddressCast(base, LIRKind.value((PlatformKind)OCLKind.HALF));
        Value input = generator.operand((Node)this.valueNode);
        if (this.indexNode == null) {
            tool.append((LIRInstruction)new OCLLIRStmt.StoreStmt(cast, (OCLUnary.MemoryAccess)addressValue, input));
        } else {
            Value index = generator.operand((Node)this.indexNode);
            tool.append((LIRInstruction)new OCLLIRStmt.StoreStmt(cast, (OCLUnary.MemoryAccess)addressValue, input, index));
        }
    }
}

