/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;

@NodeInfo(shortName="ATOMIC_INTEGER")
public class TornadoAtomicIntegerNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<TornadoAtomicIntegerNode> TYPE = NodeClass.create(TornadoAtomicIntegerNode.class);
    private final OCLKind kind;
    private boolean ATOMIC_2_0 = false;
    public static HashMap<ResolvedJavaMethod, ArrayList<Integer>> globalAtomics = new HashMap();
    public static HashMap<ResolvedJavaMethod, HashMap<Integer, Integer>> globalAtomicsParameters = new HashMap();
    private static final int DEFAULT_VALUE = -1;
    @Node.Input
    ValueNode initialValue;
    private int indexFromGlobalMemory;
    private boolean atomicsByParameter = false;

    public TornadoAtomicIntegerNode(OCLKind kind) {
        super(TYPE, (Stamp)OCLStampFactory.getStampFor(kind));
        this.kind = kind;
        this.initialValue = ConstantNode.forInt((int)0);
    }

    public void setInitialValue(ValueNode valueNode) {
        this.initialValue = valueNode;
    }

    public void setInitialValueAtUsages(ValueNode valueNode) {
        this.initialValue.replaceAtUsages((Node)valueNode);
    }

    public ValueNode getInitialValue() {
        return this.initialValue;
    }

    private void generateExpressionForOpenCL2_0(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        Variable result = tool.newVariable((ValueKind)tool.getLIRKind(StampFactory.intValue()));
        tool.append((LIRInstruction)new OCLLIRStmt.RelocatedExpressionStmt(new OCLUnary.IntrinsicAtomicDeclaration((OCLAssembler.OCLUnaryOp)OCLAssembler.OCLUnaryIntrinsic.ATOMIC_VAR_INIT, (AllocatableValue)result, gen.operand((Node)this.initialValue))));
        gen.setResult((ValueNode)this, (Value)result);
    }

    private void generateExpressionForOpenCL1_0(NodeLIRBuilderTool gen) {
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        Variable result = tool.newVariable((ValueKind)tool.getLIRKind(StampFactory.intValue()));
        gen.setResult((ValueNode)this, (Value)result);
    }

    public int getIndexFromGlobalMemory() {
        return this.indexFromGlobalMemory;
    }

    private int getIntFromValueNode() {
        if (this.initialValue instanceof ConstantNode) {
            ConstantNode c = (ConstantNode)this.initialValue;
            return Integer.parseInt(c.getValue().toValueString());
        }
        throw new TornadoRuntimeException("Value node not implemented for Atomics");
    }

    private void updateGlobalAtomicTable(HashMap positions, int paramIndex, int size) {
        positions.put(paramIndex, size);
        globalAtomicsParameters.put(this.graph().method(), positions);
    }

    public synchronized void assignIndexFromParameter(int paramIndex) {
        if (!globalAtomics.containsKey(this.graph().method())) {
            ArrayList<Integer> al = new ArrayList<Integer>();
            al.add(-1);
            globalAtomics.put(this.graph().method(), al);
            this.updateGlobalAtomicTable(new HashMap(), paramIndex, al.size() - 1);
            this.indexFromGlobalMemory = 0;
        } else {
            ArrayList<Integer> al = globalAtomics.get(this.graph().method());
            this.indexFromGlobalMemory = al.size();
            al.add(-1);
            globalAtomics.put(this.graph().method(), al);
            HashMap<Integer, Integer> positions = globalAtomicsParameters.get(this.graph().method());
            this.updateGlobalAtomicTable(positions, paramIndex, al.size() - 1);
        }
        this.atomicsByParameter = true;
    }

    public boolean isAtomicsByParameter() {
        return this.atomicsByParameter;
    }

    private synchronized void assignIndex() {
        if (!globalAtomics.containsKey(this.graph().method())) {
            ArrayList<Integer> al = new ArrayList<Integer>();
            al.add(this.getIntFromValueNode());
            globalAtomics.put(this.graph().method(), al);
            this.indexFromGlobalMemory = 0;
        } else {
            ArrayList<Integer> al = globalAtomics.get(this.graph().method());
            this.indexFromGlobalMemory = al.size();
            al.add(this.getIntFromValueNode());
            globalAtomics.put(this.graph().method(), al);
        }
    }

    public void generate(NodeLIRBuilderTool gen) {
        if (this.ATOMIC_2_0) {
            this.generateExpressionForOpenCL2_0(gen);
        } else {
            if (!this.atomicsByParameter) {
                this.assignIndex();
            }
            this.generateExpressionForOpenCL1_0(gen);
        }
    }
}

