/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLStampFactory;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLArithmeticTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.Floatable;

public class OCLIntrinsicNode {

    @NodeInfo(nameTemplate="{p#operation/s}")
    public static class BinaryGeometricOp
    extends BinaryNode
    implements ArithmeticLIRLowerable {
        public static final NodeClass<BinaryGeometricOp> TYPE = NodeClass.create(BinaryGeometricOp.class);
        protected final GeometricOp operation;

        public BinaryGeometricOp(Stamp stamp, GeometricOp op, ValueNode x, ValueNode y) {
            super(TYPE, stamp, x, y);
            this.operation = op;
        }

        public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
            return this;
        }

        public ValueNode canonical(CanonicalizerTool tool) {
            return this;
        }

        public Stamp foldStamp(Stamp stampX, Stamp stampY) {
            return this.stamp(NodeView.DEFAULT);
        }

        public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool arithmeticTool) {
            OCLBuiltinTool gen = ((OCLArithmeticTool)builder).getGen().getOCLBuiltinTool();
            Value x = builder.operand((Node)this.getX());
            Value y = builder.operand((Node)this.getY());
            Value result = null;
            switch (this.operation.ordinal()) {
                case 0: {
                    result = gen.genGeometricCross(x, y);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    result = gen.genGeometricDot(x, y);
                    break;
                }
                default: {
                    TornadoInternalError.unimplemented((String)"Default case intrinsics not implemented yet.");
                }
            }
            Variable var = builder.getLIRGeneratorTool().newVariable(result.getValueKind());
            builder.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)var, result));
            builder.setResult((ValueNode)this, (Value)var);
        }

        public void generate(NodeLIRBuilderTool builder) {
            this.generate(builder, builder.getLIRGeneratorTool().getArithmetic());
        }
    }

    @NodeInfo(nameTemplate="{p#operation/s}")
    public static final class FixedBinaryGeometricOp
    extends FixedNode
    implements Floatable {
        public static final NodeClass<FixedBinaryGeometricOp> TYPE = NodeClass.create(FixedBinaryGeometricOp.class);
        private final GeometricOp operation;
        @Node.Input
        private ValueNode x;
        @Node.Input
        private ValueNode y;

        public FixedBinaryGeometricOp(OCLKind kind, GeometricOp op, ValueNode x, ValueNode y) {
            super(TYPE, (Stamp)OCLStampFactory.getStampFor(kind.getElementKind()));
            this.operation = op;
            this.x = x;
            this.y = y;
        }

        public FloatingNode asFloating() {
            return new BinaryGeometricOp(this.stamp, this.operation, this.x, this.y);
        }
    }

    public static enum GeometricOp {
        CROSS,
        DISTANCE,
        DOT,
        LENGTH,
        NORMALISE,
        FAST_DISTANCE,
        FAST_LENGTH,
        FAST_NORMALISE;

    }

    public static enum IntegerOp {
        ATAN2,
        ATAN2PI,
        COPYSIGN,
        FDIM,
        FMA,
        FMAX,
        FMIN,
        FMOD,
        FRACT,
        FREXP,
        HYPOT,
        LDEXP,
        MAD,
        MAXMAG,
        MINMAG,
        MODF,
        NEXTAFTER,
        POW,
        POWN,
        POWR,
        REMAINDER,
        REMQUO,
        ROOTN,
        SINCOS;

    }

    public static enum FloatingOp {
        ATAN2,
        ATAN2PI,
        COPYSIGN,
        FDIM,
        FMA,
        FMAX,
        FMIN,
        FMOD,
        FRACT,
        FREXP,
        HYPOT,
        LDEXP,
        MAD,
        MAXMAG,
        MINMAG,
        MODF,
        NEXTAFTER,
        POW,
        POWN,
        POWR,
        REMAINDER,
        REMQUO,
        ROOTN,
        SINCOS;

    }
}

