/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLArithmeticTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkIntIntrinsicNode;

@NodeInfo(nameTemplate="{p#operation/s}")
public class OCLIntUnaryIntrinsicNode
extends UnaryNode
implements ArithmeticLIRLowerable,
MarkIntIntrinsicNode {
    public static final NodeClass<OCLIntUnaryIntrinsicNode> TYPE = NodeClass.create(OCLIntUnaryIntrinsicNode.class);
    protected final Operation operation;

    protected OCLIntUnaryIntrinsicNode(ValueNode x, Operation op, JavaKind kind) {
        super(TYPE, StampFactory.forKind((JavaKind)kind), x);
        this.operation = op;
    }

    public static ValueNode create(ValueNode x, Operation op, JavaKind kind) {
        ValueNode c = OCLIntUnaryIntrinsicNode.tryConstantFold(x, op, kind);
        if (c != null) {
            return c;
        }
        return new OCLIntUnaryIntrinsicNode(x, op, kind);
    }

    protected static ValueNode tryConstantFold(ValueNode x, Operation op, JavaKind kind) {
        ConstantNode result = null;
        if (x.isConstant()) {
            if (kind == JavaKind.Int) {
                int ret = OCLIntUnaryIntrinsicNode.doCompute(x.asJavaConstant().asInt(), op);
                result = ConstantNode.forInt((int)ret);
            } else if (kind == JavaKind.Long) {
                long ret = OCLIntUnaryIntrinsicNode.doCompute(x.asJavaConstant().asLong(), op);
                result = ConstantNode.forLong((long)ret);
            }
        }
        return result;
    }

    private static long doCompute(long value, Operation op) {
        switch (op.ordinal()) {
            case 0: {
                return Math.abs(value);
            }
            case 1: {
                return Long.numberOfLeadingZeros(value);
            }
            case 2: {
                return Long.bitCount(value);
            }
        }
        throw new TornadoInternalError("unknown op %s", new Object[]{op});
    }

    private static int doCompute(int value, Operation op) {
        switch (op.ordinal()) {
            case 0: {
                return Math.abs(value);
            }
            case 1: {
                return Integer.numberOfLeadingZeros(value);
            }
            case 2: {
                return Integer.bitCount(value);
            }
        }
        throw new TornadoInternalError("unknown op %s", new Object[]{op});
    }

    public String getOperation() {
        return this.operation.toString();
    }

    public Operation operation() {
        return this.operation;
    }

    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool lirGen) {
        OCLBuiltinTool gen = ((OCLArithmeticTool)lirGen).getGen().getOCLBuiltinTool();
        Value x = builder.operand((Node)this.getValue());
        Value result = switch (this.operation().ordinal()) {
            case 0 -> gen.genIntAbs(x);
            case 1 -> gen.genIntClz(x);
            case 2 -> gen.genIntPopcount(x);
            default -> throw TornadoInternalError.shouldNotReachHere();
        };
        Variable var = builder.getLIRGeneratorTool().newVariable(result.getValueKind());
        builder.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)var, result));
        builder.setResult((ValueNode)this, (Value)var);
    }

    public Node canonical(CanonicalizerTool tool, ValueNode value) {
        ValueNode c = OCLIntUnaryIntrinsicNode.tryConstantFold(value, this.operation(), this.getStackKind());
        if (c != null) {
            return c;
        }
        return this;
    }

    public static enum Operation {
        ABS,
        CLZ,
        POPCOUNT;

    }
}

