/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.TernaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLArithmeticTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkIntIntrinsicNode;

@NodeInfo(nameTemplate="{p#operation/s}")
public class OCLIntTernaryIntrinsicNode
extends TernaryNode
implements ArithmeticLIRLowerable,
MarkIntIntrinsicNode {
    public static final NodeClass<OCLIntTernaryIntrinsicNode> TYPE = NodeClass.create(OCLIntTernaryIntrinsicNode.class);
    protected final Operation operation;

    protected OCLIntTernaryIntrinsicNode(ValueNode x, ValueNode y, ValueNode z, Operation op, JavaKind kind) {
        super(TYPE, StampFactory.forKind((JavaKind)kind), x, y, z);
        this.operation = op;
    }

    public static ValueNode create(ValueNode x, ValueNode y, ValueNode z, Operation op, JavaKind kind) {
        ValueNode c = OCLIntTernaryIntrinsicNode.tryConstantFold(x, y, z, op, kind);
        if (c != null) {
            return c;
        }
        return new OCLIntTernaryIntrinsicNode(x, y, z, op, kind);
    }

    protected static ValueNode tryConstantFold(ValueNode x, ValueNode y, ValueNode z, Operation op, JavaKind kind) {
        ConstantNode result = null;
        if (x.isConstant() && y.isConstant() && z.isConstant()) {
            if (kind == JavaKind.Int) {
                int ret = OCLIntTernaryIntrinsicNode.doCompute(x.asJavaConstant().asInt(), y.asJavaConstant().asInt(), z.asJavaConstant().asInt(), op);
                result = ConstantNode.forInt((int)ret);
            } else if (kind == JavaKind.Long) {
                long ret = OCLIntTernaryIntrinsicNode.doCompute(x.asJavaConstant().asLong(), y.asJavaConstant().asLong(), (long)z.asJavaConstant().asInt(), op);
                result = ConstantNode.forLong((long)ret);
            }
        }
        return result;
    }

    private static long doCompute(long x, long y, long z, Operation op) {
        switch (op.ordinal()) {
            case 0: {
                return TornadoMath.clamp((long)x, (long)y, (long)z);
            }
        }
        throw new TornadoInternalError("unknown op %s", new Object[]{op});
    }

    private static int doCompute(int x, int y, int z, Operation op) {
        switch (op.ordinal()) {
            case 0: {
                return TornadoMath.clamp((int)x, (int)y, (int)z);
            }
        }
        throw new TornadoInternalError("unknown op %s", new Object[]{op});
    }

    public Stamp foldStamp(Stamp stampX, Stamp stampY, Stamp stampZ) {
        return this.stamp(NodeView.DEFAULT);
    }

    public String getOperation() {
        return this.operation.toString();
    }

    public Operation operation() {
        return this.operation;
    }

    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool lirGen) {
        OCLBuiltinTool gen = ((OCLArithmeticTool)lirGen).getGen().getOCLBuiltinTool();
        Value x = builder.operand((Node)this.getX());
        Value y = builder.operand((Node)this.getY());
        Value z = builder.operand((Node)this.getZ());
        LIRKind lirKind = builder.getLIRGeneratorTool().getLIRKind(this.stamp);
        Variable result = builder.getLIRGeneratorTool().newVariable((ValueKind)lirKind);
        builder.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)result, switch (this.operation().ordinal()) {
            case 0 -> gen.genIntClamp(x, y, z);
            case 3 -> gen.genIntMad24(x, y, z);
            case 1 -> gen.genIntMadHi(x, y, z);
            case 2 -> gen.genIntMadSat(x, y, z);
            default -> throw TornadoInternalError.shouldNotReachHere();
        }));
        builder.setResult((ValueNode)this, (Value)result);
    }

    public Node canonical(CanonicalizerTool tool, ValueNode x, ValueNode y, ValueNode z) {
        ValueNode c = OCLIntTernaryIntrinsicNode.tryConstantFold(x, y, z, this.operation(), this.getStackKind());
        if (c != null) {
            return c;
        }
        return this;
    }

    public static enum Operation {
        CLAMP,
        MAD_HI,
        MAD_SAT,
        MAD24;

    }
}

