/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLArithmeticTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkIntIntrinsicNode;

@NodeInfo(nameTemplate="{p#operation/s}")
public class OCLIntBinaryIntrinsicNode
extends BinaryNode
implements ArithmeticLIRLowerable,
MarkIntIntrinsicNode {
    public static final NodeClass<OCLIntBinaryIntrinsicNode> TYPE = NodeClass.create(OCLIntBinaryIntrinsicNode.class);
    protected final Operation operation;

    protected OCLIntBinaryIntrinsicNode(ValueNode x, ValueNode y, Operation op, JavaKind kind) {
        super(TYPE, StampFactory.forKind((JavaKind)kind), x, y);
        this.operation = op;
    }

    public static ValueNode create(ValueNode x, ValueNode y, Operation op, JavaKind kind) {
        ValueNode c = OCLIntBinaryIntrinsicNode.tryConstantFold(x, y, op, kind);
        if (c != null) {
            return c;
        }
        return new OCLIntBinaryIntrinsicNode(x, y, op, kind);
    }

    protected static ValueNode tryConstantFold(ValueNode x, ValueNode y, Operation op, JavaKind kind) {
        ConstantNode result = null;
        if (x.isConstant() && y.isConstant()) {
            if (kind == JavaKind.Int) {
                int ret = OCLIntBinaryIntrinsicNode.doCompute(x.asJavaConstant().asInt(), y.asJavaConstant().asInt(), op);
                result = ConstantNode.forInt((int)ret);
            } else if (kind == JavaKind.Long) {
                long ret = OCLIntBinaryIntrinsicNode.doCompute(x.asJavaConstant().asLong(), y.asJavaConstant().asLong(), op);
                result = ConstantNode.forLong((long)ret);
            }
        }
        return result;
    }

    private static long doCompute(long x, long y, Operation op) {
        switch (op.ordinal()) {
            case 5: {
                return Math.min(x, y);
            }
            case 4: {
                return Math.max(x, y);
            }
        }
        throw new TornadoInternalError("unknown op %s", new Object[]{op});
    }

    private static int doCompute(int x, int y, Operation op) {
        switch (op.ordinal()) {
            case 5: {
                return Math.min(x, y);
            }
            case 4: {
                return Math.max(x, y);
            }
        }
        throw new TornadoInternalError("unknown op %s", new Object[]{op});
    }

    public String getOperation() {
        return this.operation.toString();
    }

    public ValueNode canonical(CanonicalizerTool tool) {
        return this.canonical(tool, this.getX(), this.getY());
    }

    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return this.stamp(NodeView.DEFAULT);
    }

    public void generate(NodeLIRBuilderTool tool) {
        this.generate(tool, tool.getLIRGeneratorTool().getArithmetic());
    }

    public Operation operation() {
        return this.operation;
    }

    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool lirGen) {
        OCLBuiltinTool gen = ((OCLArithmeticTool)lirGen).getGen().getOCLBuiltinTool();
        Value x = builder.operand((Node)this.getX());
        Value y = builder.operand((Node)this.getY());
        Value result = switch (this.operation().ordinal()) {
            case 5 -> gen.genIntMin(x, y);
            case 4 -> gen.genIntMax(x, y);
            default -> throw TornadoInternalError.shouldNotReachHere();
        };
        Variable var = builder.getLIRGeneratorTool().newVariable(result.getValueKind());
        builder.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)var, result));
        builder.setResult((ValueNode)this, (Value)var);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode x, ValueNode y) {
        ValueNode c = OCLIntBinaryIntrinsicNode.tryConstantFold(x, y, this.operation(), this.getStackKind());
        if (c != null) {
            return c;
        }
        return this;
    }

    public static enum Operation {
        ABS_DIFF,
        ABS_SAT,
        HADD,
        RHADD,
        MAX,
        MIN,
        MUL_HI,
        ROTATE,
        SUB_SAT,
        UPSAMPLE,
        MUL24;

    }
}

