/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLArithmeticTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkFloatingPointIntrinsicsNode;

@NodeInfo(nameTemplate="{p#operation/s}")
public class OCLFPUnaryIntrinsicNode
extends UnaryNode
implements ArithmeticLIRLowerable,
MarkFloatingPointIntrinsicsNode {
    public static final NodeClass<OCLFPUnaryIntrinsicNode> TYPE = NodeClass.create(OCLFPUnaryIntrinsicNode.class);
    protected final Operation operation;

    protected OCLFPUnaryIntrinsicNode(ValueNode value, Operation op, JavaKind kind) {
        super(TYPE, StampFactory.forKind((JavaKind)kind), value);
        assert (value.stamp(NodeView.DEFAULT) instanceof FloatStamp && PrimitiveStamp.getBits((Stamp)value.stamp(NodeView.DEFAULT)) == kind.getBitCount());
        this.operation = op;
    }

    public static ValueNode create(ValueNode value, Operation op, JavaKind kind) {
        ValueNode c = OCLFPUnaryIntrinsicNode.tryConstantFold(value, op, kind);
        if (c != null) {
            return c;
        }
        return new OCLFPUnaryIntrinsicNode(value, op, kind);
    }

    protected static ValueNode tryConstantFold(ValueNode value, Operation op, JavaKind kind) {
        ConstantNode result = null;
        if (value.isConstant()) {
            if (kind == JavaKind.Double) {
                double ret = OCLFPUnaryIntrinsicNode.doCompute(value.asJavaConstant().asDouble(), op);
                result = ConstantNode.forDouble((double)ret);
            } else if (kind == JavaKind.Float) {
                float ret = OCLFPUnaryIntrinsicNode.doCompute(value.asJavaConstant().asFloat(), op);
                result = ConstantNode.forFloat((float)ret);
            }
        }
        return result;
    }

    private static double computeAcosh(double value) {
        return Math.log(value + Math.sqrt(value * value - 1.0));
    }

    private static float computeAcosh(float value) {
        return (float)Math.log((double)value + Math.sqrt(value * value - 1.0f));
    }

    private static double computeAsinh(double value) {
        return Math.log(value + Math.sqrt(value * value + 1.0));
    }

    private static float computeAsinh(float value) {
        return (float)Math.log((double)value + Math.sqrt(value * value + 1.0f));
    }

    private static double doCompute(double value, Operation op) {
        return switch (op.ordinal()) {
            case 3 -> Math.asin(value);
            case 4 -> OCLFPUnaryIntrinsicNode.computeAsinh(value);
            case 0 -> Math.acos(value);
            case 1 -> OCLFPUnaryIntrinsicNode.computeAcosh(value);
            case 20 -> Math.abs(value);
            case 16 -> Math.exp(value);
            case 38 -> Math.sqrt(value);
            case 21 -> Math.floor(value);
            case 24 -> Math.log(value);
            default -> throw new TornadoInternalError("unable to compute op %s", new Object[]{op});
        };
    }

    private static float doCompute(float value, Operation op) {
        return switch (op.ordinal()) {
            case 3 -> (float)Math.asin(value);
            case 4 -> OCLFPUnaryIntrinsicNode.computeAsinh(value);
            case 0 -> (float)Math.acos(value);
            case 1 -> OCLFPUnaryIntrinsicNode.computeAcosh(value);
            case 20 -> Math.abs(value);
            case 16 -> (float)Math.exp(value);
            case 38 -> (float)Math.sqrt(value);
            case 21 -> (float)Math.floor(value);
            case 24 -> (float)Math.log(value);
            default -> throw new TornadoInternalError("unable to compute op %s", new Object[]{op});
        };
    }

    public String getOperation() {
        return this.operation.toString();
    }

    public Operation getIntrinsicOperation() {
        return this.operation;
    }

    public Operation operation() {
        return this.operation;
    }

    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode c = OCLFPUnaryIntrinsicNode.tryConstantFold(forValue, this.operation(), forValue.getStackKind());
        if (c != null) {
            return c;
        }
        return this;
    }

    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool lirGen) {
        OCLBuiltinTool gen = ((OCLArithmeticTool)lirGen).getGen().getOCLBuiltinTool();
        Value input = builder.operand((Node)this.getValue());
        Value result = switch (this.operation().ordinal()) {
            case 1 -> gen.genFloatACosh(input);
            case 3 -> gen.genFloatASin(input);
            case 4 -> gen.genFloatASinh(input);
            case 0 -> gen.genFloatACos(input);
            case 6 -> gen.genFloatATan(input);
            case 10 -> gen.genFloatCeil(input);
            case 11 -> gen.genFloatCos(input);
            case 20 -> gen.genFloatAbs(input);
            case 16 -> gen.genFloatExp(input);
            case 35 -> gen.genFloatSin(input);
            case 38 -> gen.genFloatSqrt(input);
            case 39 -> gen.genFloatTan(input);
            case 40 -> gen.genFloatTanh(input);
            case 21 -> gen.genFloatFloor(input);
            case 24 -> gen.genFloatLog(input);
            case 30 -> gen.genFloatRadians(input);
            case 13 -> gen.genFloatCosPI(input);
            case 37 -> gen.genFloatSinPI(input);
            default -> throw TornadoInternalError.shouldNotReachHere();
        };
        Variable x = builder.getLIRGeneratorTool().newVariable(result.getValueKind());
        builder.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)x, result));
        builder.setResult((ValueNode)this, (Value)x);
    }

    public static enum Operation {
        ACOS,
        ACOSH,
        ACOSPI,
        ASIN,
        ASINH,
        ASINPI,
        ATAN,
        ATANH,
        ATANPI,
        CBRT,
        CEIL,
        COS,
        COSH,
        COSPI,
        ERFC,
        ERF,
        EXP,
        EXP2,
        EXP10,
        EXPM1,
        FABS,
        FLOOR,
        ILOGB,
        LGAMMA,
        LOG,
        LOG2,
        LOG10,
        LOG1P,
        LOGB,
        NAN,
        RADIANS,
        REMQUO,
        RINT,
        ROUND,
        RSQRT,
        SIN,
        SINH,
        SINPI,
        SQRT,
        TAN,
        TANH,
        TANPI,
        TGAMMA,
        TRUNC;

    }
}

