/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.TernaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLArithmeticTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkFloatingPointIntrinsicsNode;

@NodeInfo(nameTemplate="{p#operation/s}")
public class OCLFPTernaryIntrinsicNode
extends TernaryNode
implements ArithmeticLIRLowerable,
MarkFloatingPointIntrinsicsNode {
    public static final NodeClass<OCLFPTernaryIntrinsicNode> TYPE = NodeClass.create(OCLFPTernaryIntrinsicNode.class);
    protected final Operation operation;

    protected OCLFPTernaryIntrinsicNode(ValueNode x, ValueNode y, ValueNode z, Operation op, JavaKind kind) {
        super(TYPE, StampFactory.forKind((JavaKind)kind), x, y, z);
        this.operation = op;
    }

    public static ValueNode create(ValueNode x, ValueNode y, ValueNode z, Operation op, JavaKind kind) {
        ValueNode c = OCLFPTernaryIntrinsicNode.tryConstantFold(x, y, z, op, kind);
        if (c != null) {
            return c;
        }
        return new OCLFPTernaryIntrinsicNode(x, y, z, op, kind);
    }

    protected static ValueNode tryConstantFold(ValueNode x, ValueNode y, ValueNode z, Operation op, JavaKind kind) {
        ConstantNode result = null;
        if (x.isConstant() && y.isConstant() && z.isConstant()) {
            if (kind == JavaKind.Double) {
                double ret = OCLFPTernaryIntrinsicNode.doCompute(x.asJavaConstant().asDouble(), y.asJavaConstant().asDouble(), z.asJavaConstant().asDouble(), op);
                result = ConstantNode.forDouble((double)ret);
            } else if (kind == JavaKind.Float) {
                float ret = OCLFPTernaryIntrinsicNode.doCompute(x.asJavaConstant().asFloat(), y.asJavaConstant().asFloat(), z.asJavaConstant().asFloat(), op);
                result = ConstantNode.forFloat((float)ret);
            }
        }
        return result;
    }

    private static double doCompute(double x, double y, double z, Operation op) {
        throw new TornadoInternalError("unable to compute op %s", new Object[]{op});
    }

    private static float doCompute(float x, float y, float z, Operation op) {
        throw new TornadoInternalError("unable to compute  op %s", new Object[]{op});
    }

    public Stamp foldStamp(Stamp stampX, Stamp stampY, Stamp stampZ) {
        return this.stamp(NodeView.DEFAULT);
    }

    public String getOperation() {
        return this.operation.toString();
    }

    public Operation operation() {
        return this.operation;
    }

    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool lirGen) {
        OCLBuiltinTool gen = ((OCLArithmeticTool)lirGen).getGen().getOCLBuiltinTool();
        Value x = builder.operand((Node)this.getX());
        Value y = builder.operand((Node)this.getY());
        Value z = builder.operand((Node)this.getZ());
        Value result = switch (this.operation().ordinal()) {
            case 0 -> gen.genFloatFMA(x, y, z);
            case 1 -> gen.genFloatMAD(x, y, z);
            case 2 -> gen.genFloatRemquo(x, y, z);
            default -> throw TornadoInternalError.shouldNotReachHere();
        };
        Variable var = builder.getLIRGeneratorTool().newVariable(result.getValueKind());
        builder.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)var, result));
        builder.setResult((ValueNode)this, (Value)var);
    }

    public Node canonical(CanonicalizerTool tool, ValueNode x, ValueNode y, ValueNode z) {
        ValueNode c = OCLFPTernaryIntrinsicNode.tryConstantFold(x, y, z, this.operation(), this.getStackKind());
        if (c != null) {
            return c;
        }
        return this;
    }

    public static enum Operation {
        FMA,
        MAD,
        REMQUO;

    }
}

