/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLArithmeticTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBuiltinTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkFloatingPointIntrinsicsNode;

@NodeInfo(nameTemplate="{p#operation/s}")
public class OCLFPBinaryIntrinsicNode
extends BinaryNode
implements ArithmeticLIRLowerable,
MarkFloatingPointIntrinsicsNode {
    public static final NodeClass<OCLFPBinaryIntrinsicNode> TYPE = NodeClass.create(OCLFPBinaryIntrinsicNode.class);
    protected final Operation operation;

    protected OCLFPBinaryIntrinsicNode(ValueNode x, ValueNode y, Operation op, JavaKind kind) {
        super(TYPE, StampFactory.forKind((JavaKind)kind), x, y);
        this.operation = op;
    }

    public static ValueNode create(ValueNode x, ValueNode y, Operation op, JavaKind kind) {
        ValueNode c = OCLFPBinaryIntrinsicNode.tryConstantFold(x, y, op, kind);
        if (c != null) {
            return c;
        }
        return new OCLFPBinaryIntrinsicNode(x, y, op, kind);
    }

    protected static ValueNode tryConstantFold(ValueNode x, ValueNode y, Operation op, JavaKind kind) {
        ConstantNode result = null;
        if (x.isConstant() && y.isConstant()) {
            if (kind == JavaKind.Double) {
                double ret = OCLFPBinaryIntrinsicNode.doCompute(x.asJavaConstant().asDouble(), y.asJavaConstant().asDouble(), op);
                result = ConstantNode.forDouble((double)ret);
            } else if (kind == JavaKind.Float) {
                float ret = OCLFPBinaryIntrinsicNode.doCompute(x.asJavaConstant().asFloat(), y.asJavaConstant().asFloat(), op);
                result = ConstantNode.forFloat((float)ret);
            }
        }
        return result;
    }

    private static double doCompute(double x, double y, Operation op) {
        switch (op.ordinal()) {
            case 0: {
                return Math.atan2(x, y);
            }
            case 6: {
                return Math.min(x, y);
            }
            case 5: {
                return Math.max(x, y);
            }
            case 17: {
                return Math.pow(x, y);
            }
        }
        throw new TornadoInternalError("unknown op %s", new Object[]{op});
    }

    private static float doCompute(float x, float y, Operation op) {
        switch (op.ordinal()) {
            case 0: {
                return (float)Math.atan2(x, y);
            }
            case 6: {
                return Math.min(x, y);
            }
            case 5: {
                return Math.max(x, y);
            }
        }
        throw new TornadoInternalError("unknown op %s", new Object[]{op});
    }

    public String getOperation() {
        return this.operation.toString();
    }

    public ValueNode canonical(CanonicalizerTool tool) {
        return this.canonical(tool, this.getX(), this.getY());
    }

    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return this.stamp(NodeView.DEFAULT);
    }

    public void generate(NodeLIRBuilderTool builder) {
        this.generate(builder, builder.getLIRGeneratorTool().getArithmetic());
    }

    public Operation operation() {
        return this.operation;
    }

    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool lirGen) {
        OCLBuiltinTool gen = ((OCLArithmeticTool)lirGen).getGen().getOCLBuiltinTool();
        Value x = builder.operand((Node)this.getX());
        Value y = builder.operand((Node)this.getY());
        Value result = switch (this.operation().ordinal()) {
            case 0 -> gen.genFloatATan2(x, y);
            case 6 -> gen.genFloatMin(x, y);
            case 5 -> gen.genFloatMax(x, y);
            case 17 -> gen.genFloatPow(x, y);
            default -> throw TornadoInternalError.shouldNotReachHere();
        };
        Variable var = builder.getLIRGeneratorTool().newVariable(result.getValueKind());
        builder.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)var, result));
        builder.setResult((ValueNode)this, (Value)var);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode x, ValueNode y) {
        ValueNode c = OCLFPBinaryIntrinsicNode.tryConstantFold(x, y, this.operation(), this.getStackKind());
        if (c != null) {
            return c;
        }
        return this;
    }

    public static enum Operation {
        ATAN2,
        ATAN2PI,
        COPYSIGN,
        FDIM,
        FMA,
        FMAX,
        FMIN,
        FMOD,
        FRACT,
        FREXP,
        HYPOT,
        LDEXP,
        MAD,
        MAXMAG,
        MINMAG,
        MODF,
        NEXTAFTER,
        POW,
        POWN,
        POWR,
        REMAINDER,
        REMQUO,
        ROOTN,
        SINCOS;

    }
}

