/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLLIRGenerator;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;

@NodeInfo
public class OCLDecompressedReadFieldNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<OCLDecompressedReadFieldNode> TYPE = NodeClass.create(OCLDecompressedReadFieldNode.class);
    @Node.Input
    private ValueNode object;
    @Node.Input
    private AddressNode address;

    public OCLDecompressedReadFieldNode(ValueNode object, AddressNode address, Stamp stamp) {
        super(TYPE, stamp);
        this.object = object;
        this.address = address;
    }

    public ValueNode getObject() {
        return this.object;
    }

    public void generate(NodeLIRBuilderTool gen) {
        OCLLIRGenerator tool = (OCLLIRGenerator)gen.getLIRGeneratorTool();
        Value addressBase = gen.operand((Node)this.address.getBase());
        Value index = gen.operand((Node)this.address.getIndex());
        Variable fieldAddress = tool.getArithmetic().emitAdd(addressBase, index, false);
        Variable compressedPointer = tool.newVariable((ValueKind<?>)LIRKind.value((PlatformKind)OCLKind.UINT));
        tool.append(new OCLLIRStmt.CastCompressedStmt((Value)compressedPointer, (Value)fieldAddress));
        Variable decompressedPointer = tool.newVariable((ValueKind<?>)LIRKind.value((PlatformKind)OCLKind.ULONG));
        tool.append(new OCLLIRStmt.DecompressPointerStmt((Value)decompressedPointer, addressBase, (Value)compressedPointer));
        gen.setResult((ValueNode)this, (Value)decompressedPointer);
    }
}

