/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;

@NodeInfo
public class OCLConvertHalfToFloat
extends ValueNode
implements LIRLowerable {
    public static final NodeClass<OCLConvertHalfToFloat> TYPE = NodeClass.create(OCLConvertHalfToFloat.class);
    @Node.Input
    private ValueNode halfValueNode;

    public OCLConvertHalfToFloat(ValueNode halfValueNode) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Float));
        this.halfValueNode = halfValueNode;
    }

    public void generate(NodeLIRBuilderTool generator) {
        LIRGeneratorTool tool = generator.getLIRGeneratorTool();
        Variable floatValue = tool.newVariable((ValueKind)LIRKind.value((PlatformKind)OCLKind.FLOAT));
        Value halfValue = generator.operand((Node)this.halfValueNode);
        tool.append((LIRInstruction)new OCLLIRStmt.ConvertHalfToFloatStmt((Value)floatValue, halfValue));
        generator.setResult((ValueNode)this, (Value)floatValue);
    }
}

