/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;

@NodeInfo
public class OCLConvertFloatToHalf
extends ValueNode
implements LIRLowerable {
    public static final NodeClass<OCLConvertFloatToHalf> TYPE = NodeClass.create(OCLConvertFloatToHalf.class);
    @Node.Input
    private ValueNode floatValueNode;

    public OCLConvertFloatToHalf(ValueNode floatValueNode) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Short));
        this.floatValueNode = floatValueNode;
    }

    public void generate(NodeLIRBuilderTool generator) {
        LIRGeneratorTool tool = generator.getLIRGeneratorTool();
        Variable halfValue = tool.newVariable((ValueKind)LIRKind.value((PlatformKind)OCLKind.HALF));
        Value floatValue = generator.operand((Node)this.floatValueNode);
        tool.append((LIRInstruction)new OCLLIRStmt.ConvertFloatToHalfStmt(floatValue, (Value)halfValue));
        generator.setResult((ValueNode)this, (Value)halfValue);
    }
}

