/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkLocalArray;

@NodeInfo
public class LocalArrayNode
extends FixedNode
implements LIRLowerable,
MarkLocalArray,
MemoryKill {
    public static final NodeClass<LocalArrayNode> TYPE = NodeClass.create(LocalArrayNode.class);
    @Node.Input
    protected ValueNode length;
    protected OCLArchitecture.OCLMemoryBase memoryRegister;
    protected OCLAssembler.OCLBinaryTemplate arrayTemplate;
    private OCLKind kind;

    public LocalArrayNode(OCLArchitecture.OCLMemoryBase memoryRegister, ResolvedJavaType elementType, ValueNode length) {
        super(TYPE, (Stamp)StampFactory.objectNonNull((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)elementType.getArrayClass())));
        this.memoryRegister = memoryRegister;
        this.length = length;
        this.kind = OCLKind.fromResolvedJavaType(elementType);
        this.arrayTemplate = OCLKind.resolveTemplateType(elementType, this.kind);
    }

    public LocalArrayNode(OCLArchitecture.OCLMemoryBase memoryRegister, ResolvedJavaType elementType, ValueNode length, OCLKind kind) {
        super(TYPE, (Stamp)StampFactory.objectNonNull((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)elementType.getArrayClass())));
        this.memoryRegister = memoryRegister;
        this.length = length;
        this.kind = kind;
        this.arrayTemplate = OCLKind.resolveTemplateType(elementType, this.kind);
    }

    public LocalArrayNode(OCLArchitecture.OCLMemoryBase memoryRegister, JavaKind elementKind, ValueNode length) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Object));
        this.memoryRegister = memoryRegister;
        this.length = length;
        this.kind = OCLKind.fromResolvedJavaKind(elementKind);
        this.arrayTemplate = OCLKind.resolveTemplateType(elementKind, this.kind);
    }

    public OCLArchitecture.OCLMemoryBase getMemoryRegister() {
        return this.memoryRegister;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public OCLKind getOCLKind() {
        return this.kind;
    }

    public void generate(NodeLIRBuilderTool gen) {
        Value lengthValue = gen.operand((Node)this.length);
        LIRKind lirKind = LIRKind.value((PlatformKind)this.kind);
        Variable variable = gen.getLIRGeneratorTool().newVariable((ValueKind)lirKind);
        OCLBinary.Expr declaration = new OCLBinary.Expr(this.arrayTemplate, lirKind, (Value)variable, lengthValue);
        OCLLIRStmt.ExprStmt expr = new OCLLIRStmt.ExprStmt(declaration);
        gen.getLIRGeneratorTool().append((LIRInstruction)expr);
        gen.setResult((ValueNode)this, (Value)variable);
    }
}

