/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.NodeAtomic;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.TornadoAtomicIntegerNode;

@NodeInfo(shortName="INCREMENT_ATOMIC")
public class IncAtomicNode
extends NodeAtomic
implements LIRLowerable {
    public static final NodeClass<IncAtomicNode> TYPE = NodeClass.create(IncAtomicNode.class);
    private static boolean ATOMIC_2_0 = false;
    @Node.Input
    ValueNode atomicNode;
    OCLUnary.AtomicOperator atomicOperator;

    public IncAtomicNode(ValueNode atomicValue, OCLUnary.AtomicOperator atomicOperator) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Int));
        this.atomicNode = atomicValue;
        this.atomicOperator = atomicOperator;
    }

    @Override
    public ValueNode getAtomicNode() {
        return this.atomicNode;
    }

    private void generateExpressionForOpenCL2_0(NodeLIRBuilderTool generator) {
        LIRGeneratorTool tool = generator.getLIRGeneratorTool();
        Variable result = tool.newVariable((ValueKind)tool.getLIRKind(this.stamp));
        OCLUnary.IntrinsicAtomicFetch intrinsicAtomicFetch = new OCLUnary.IntrinsicAtomicFetch(OCLAssembler.OCLUnaryIntrinsic.ATOMIC_FETCH_ADD_EXPLICIT, tool.getLIRKind(this.stamp), generator.operand((Node)this.atomicNode));
        OCLLIRStmt.AssignStmt assignStmt = new OCLLIRStmt.AssignStmt((AllocatableValue)result, intrinsicAtomicFetch);
        tool.append((LIRInstruction)assignStmt);
        generator.setResult((ValueNode)this, (Value)result);
    }

    private void generateExpressionForOpenCL1_0(NodeLIRBuilderTool generator) {
        LIRGeneratorTool tool = generator.getLIRGeneratorTool();
        Variable result = tool.newVariable((ValueKind)tool.getLIRKind(this.stamp));
        if (this.atomicNode instanceof TornadoAtomicIntegerNode) {
            TornadoAtomicIntegerNode atomicIntegerNode = (TornadoAtomicIntegerNode)this.atomicNode;
            int indexFromGlobal = atomicIntegerNode.getIndexFromGlobalMemory();
            OCLUnary.IntrinsicAtomicOperator intrinsicAtomicAdd = new OCLUnary.IntrinsicAtomicOperator(OCLAssembler.OCLUnaryIntrinsic.ATOMIC_INC, tool.getLIRKind(this.stamp), generator.operand((Node)this.atomicNode), indexFromGlobal, this.atomicOperator);
            OCLLIRStmt.AssignStmt assignStmt = new OCLLIRStmt.AssignStmt((AllocatableValue)result, intrinsicAtomicAdd);
            tool.append((LIRInstruction)assignStmt);
            generator.setResult((ValueNode)this, (Value)result);
        }
    }

    public void generate(NodeLIRBuilderTool generator) {
        if (ATOMIC_2_0) {
            this.generateExpressionForOpenCL2_0(generator);
        } else {
            this.generateExpressionForOpenCL1_0(generator);
        }
    }
}

