/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.NodeAtomic;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.TornadoAtomicIntegerNode;

@NodeInfo(shortName="GET_ATOMIC_VALUE")
public class GetAtomicNode
extends NodeAtomic
implements LIRLowerable {
    public static final NodeClass<GetAtomicNode> TYPE = NodeClass.create(GetAtomicNode.class);
    @Node.Input
    ValueNode atomicNode;

    public GetAtomicNode(ValueNode atomicValue) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Int));
        this.atomicNode = atomicValue;
    }

    public void generate(NodeLIRBuilderTool generator) {
        LIRGeneratorTool tool = generator.getLIRGeneratorTool();
        Variable result = tool.newVariable((ValueKind)tool.getLIRKind(this.stamp));
        if (this.atomicNode instanceof TornadoAtomicIntegerNode) {
            TornadoAtomicIntegerNode atomicIntegerNode = (TornadoAtomicIntegerNode)this.atomicNode;
            int indexFromGlobal = atomicIntegerNode.getIndexFromGlobalMemory();
            OCLUnary.IntrinsicAtomicGet atomicGet = new OCLUnary.IntrinsicAtomicGet(OCLAssembler.OCLUnaryIntrinsic.ATOMIC_GET, tool.getLIRKind(this.stamp), generator.operand((Node)this.atomicNode), indexFromGlobal);
            OCLLIRStmt.AssignStmt assignStmt = new OCLLIRStmt.AssignStmt((AllocatableValue)result, atomicGet);
            tool.append((LIRInstruction)assignStmt);
            generator.setResult((ValueNode)this, (Value)result);
        }
    }

    @Override
    public ValueNode getAtomicNode() {
        return this.atomicNode;
    }
}

