/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;

@NodeInfo
public class FixedArrayNode
extends FixedNode
implements LIRLowerable {
    public static final NodeClass<FixedArrayNode> TYPE = NodeClass.create(FixedArrayNode.class);
    @Node.Input
    protected ConstantNode length;
    protected OCLKind elementKind;
    protected OCLArchitecture.OCLMemoryBase memoryRegister;
    protected ResolvedJavaType elementType;
    protected OCLAssembler.OCLBinaryTemplate arrayTemplate;
    protected OCLAssembler.OCLBinaryTemplate pointerTemplate;

    public FixedArrayNode(OCLArchitecture.OCLMemoryBase memoryRegister, ResolvedJavaType elementType, ConstantNode length) {
        super(TYPE, (Stamp)StampFactory.objectNonNull((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)elementType.getArrayClass())));
        this.memoryRegister = memoryRegister;
        this.length = length;
        this.elementType = elementType;
        this.elementKind = OCLKind.fromResolvedJavaType(elementType);
        this.arrayTemplate = OCLKind.resolvePrivateTemplateType(elementType);
        this.pointerTemplate = OCLKind.resolvePrivatePointerTemplate(elementType);
    }

    public OCLArchitecture.OCLMemoryBase getMemoryRegister() {
        return this.memoryRegister;
    }

    public ConstantNode getLength() {
        return this.length;
    }

    public ResolvedJavaType getElementType() {
        return this.elementType;
    }

    public void generate(NodeLIRBuilderTool gen) {
        Value lengthValue = gen.operand((Node)this.length);
        LIRKind lirKind = LIRKind.value((PlatformKind)gen.getLIRGeneratorTool().target().arch.getWordKind());
        Variable variable = gen.getLIRGeneratorTool().newVariable((ValueKind)lirKind);
        OCLBinary.Expr declaration = new OCLBinary.Expr(this.arrayTemplate, lirKind, (Value)variable, lengthValue);
        OCLLIRStmt.ExprStmt arrayExpr = new OCLLIRStmt.ExprStmt(declaration);
        gen.getLIRGeneratorTool().append((LIRInstruction)arrayExpr);
        Variable ptr = gen.getLIRGeneratorTool().newVariable((ValueKind)lirKind);
        OCLBinary.Expr declarationPtr = new OCLBinary.Expr(this.pointerTemplate, lirKind, (Value)ptr, (Value)variable);
        OCLLIRStmt.ExprStmt ptrExpr = new OCLLIRStmt.ExprStmt(declarationPtr);
        gen.getLIRGeneratorTool().append((LIRInstruction)ptrExpr);
        gen.setResult((ValueNode)this, (Value)ptr);
    }
}

