/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLBinary;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;

@NodeInfo
public class FixedArrayCopyNode
extends FloatingNode
implements LIRLowerable {
    public static final NodeClass<FixedArrayCopyNode> TYPE = NodeClass.create(FixedArrayCopyNode.class);
    @Node.Input
    protected ValuePhiNode conditionalPhiNode;
    protected ResolvedJavaType elementType;
    protected OCLAssembler.OCLBinaryTemplate pointerCopyTemplate;
    protected OCLArchitecture.OCLMemoryBase memoryRegister;

    public FixedArrayCopyNode(ValuePhiNode conditionalPhiNode, ResolvedJavaType elementType, OCLArchitecture.OCLMemoryBase memoryRegister) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Object));
        this.conditionalPhiNode = conditionalPhiNode;
        this.elementType = elementType;
        this.memoryRegister = memoryRegister;
        this.pointerCopyTemplate = OCLKind.resolvePrivatePointerCopyTemplate(elementType);
    }

    public OCLArchitecture.OCLMemoryBase getMemoryRegister() {
        return this.memoryRegister;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRKind lirKind = LIRKind.value((PlatformKind)gen.getLIRGeneratorTool().target().arch.getWordKind());
        Variable ptr = gen.getLIRGeneratorTool().newVariable((ValueKind)lirKind);
        Value fixedArrayValue = gen.operand((Node)this.conditionalPhiNode);
        OCLBinary.Expr declarationPtr = new OCLBinary.Expr(this.pointerCopyTemplate, lirKind, (Value)ptr, fixedArrayValue);
        OCLLIRStmt.ExprStmt ptrExpr = new OCLLIRStmt.ExprStmt(declarationPtr);
        gen.getLIRGeneratorTool().append((LIRInstruction)ptrExpr);
        gen.setResult((ValueNode)this, (Value)ptr);
    }
}

