/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.LocalWorkGroupDimensionsNode;

@NodeInfo
public class FPGAWorkGroupSizeNode
extends FixedWithNextNode
implements LIRLowerable {
    @Node.Successor
    LoopBeginNode loopBegin;
    @Node.Input
    LocalWorkGroupDimensionsNode localWorkNode;
    public static final NodeClass<FPGAWorkGroupSizeNode> TYPE = NodeClass.create(FPGAWorkGroupSizeNode.class);
    public static final String FPGA_THREAD_ATTRIBUTE_PREFIX = "__attribute__((reqd_work_group_size(";
    public static final String FPGA_THREAD_ATTRIBUTE_SUFFIX = ")))";

    public FPGAWorkGroupSizeNode(LocalWorkGroupDimensionsNode localWork) {
        super(TYPE, StampFactory.forVoid());
        this.localWorkNode = localWork;
    }

    public void generate(NodeLIRBuilderTool nodeLIRBuilderTool) {
    }

    public String createThreadAttribute() {
        String fpgaThreadAttribute = FPGA_THREAD_ATTRIBUTE_PREFIX + this.localWorkNode.getXToString() + ", " + this.localWorkNode.getYToString() + ", " + this.localWorkNode.getZToString() + FPGA_THREAD_ATTRIBUTE_SUFFIX;
        return fpgaThreadAttribute;
    }
}

