/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import uk.ac.manchester.tornado.drivers.opencl.graal.asm.OCLAssembler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLLIRStmt;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLUnary;
import uk.ac.manchester.tornado.runtime.common.exceptions.TornadoUnsupportedError;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkCastNode;

@NodeInfo
public class CastNode
extends FloatingNode
implements LIRLowerable,
MarkCastNode {
    public static final NodeClass<CastNode> TYPE = NodeClass.create(CastNode.class);
    @Node.Input
    protected ValueNode value;
    protected FloatConvert op;

    public CastNode(Stamp stamp, FloatConvert op, ValueNode value) {
        super(TYPE, stamp);
        this.op = op;
        this.value = value;
    }

    private OCLAssembler.OCLUnaryOp resolveOp() {
        switch (this.op) {
            case I2D: 
            case F2D: 
            case L2D: {
                return OCLAssembler.OCLUnaryOp.CAST_TO_DOUBLE;
            }
            case F2I: 
            case D2I: {
                return OCLAssembler.OCLUnaryOp.CAST_TO_INT;
            }
            case I2F: 
            case D2F: 
            case L2F: {
                return OCLAssembler.OCLUnaryOp.CAST_TO_FLOAT;
            }
            case D2L: 
            case F2L: {
                return OCLAssembler.OCLUnaryOp.CAST_TO_LONG;
            }
        }
        TornadoUnsupportedError.unsupported((String)"Conversion unimplemented: ", (Object[])new Object[]{this.op.toString()});
        return null;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRKind lirKind = gen.getLIRGeneratorTool().getLIRKind(this.stamp);
        OCLKind oclKind = (OCLKind)lirKind.getPlatformKind();
        Variable result = gen.getLIRGeneratorTool().newVariable((ValueKind)lirKind);
        if (oclKind.isFloating()) {
            gen.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)result, new OCLUnary.Expr(this.resolveOp(), lirKind, gen.operand((Node)this.value))));
        } else {
            gen.getLIRGeneratorTool().append((LIRInstruction)new OCLLIRStmt.AssignStmt((AllocatableValue)result, new OCLUnary.FloatCast(OCLAssembler.OCLUnaryOp.CAST_TO_INT, lirKind, gen.operand((Node)this.value))));
        }
        gen.setResult((ValueNode)this, (Value)result);
    }
}

