/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.graal.meta;

import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLArchitecture;

public class OCLMemorySpace
extends Value {
    public static final OCLMemorySpace GLOBAL = new OCLMemorySpace("__global");
    public static final OCLMemorySpace SHARED = new OCLMemorySpace("__shared");
    public static final OCLMemorySpace LOCAL = new OCLMemorySpace("__local");
    public static final OCLMemorySpace PRIVATE = new OCLMemorySpace("__private");
    public static final OCLMemorySpace CONSTANT = new OCLMemorySpace("__constant");
    private final String name;

    protected OCLMemorySpace(String name) {
        super((ValueKind)LIRKind.Illegal);
        this.name = name;
    }

    public OCLArchitecture.OCLMemoryBase getBase() {
        if (this == GLOBAL) {
            return OCLArchitecture.globalSpace;
        }
        if (this == LOCAL) {
            return OCLArchitecture.localSpace;
        }
        if (this == CONSTANT) {
            return OCLArchitecture.constantSpace;
        }
        if (this == PRIVATE) {
            return OCLArchitecture.privateSpace;
        }
        TornadoInternalError.shouldNotReachHere();
        return null;
    }

    public String name() {
        return this.name;
    }
}

